/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Date;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.transform.MaintenanceWindowExecutionTaskInvocationIdentityMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MaintenanceWindowExecutionTaskInvocationIdentity
implements StructuredPojo,
ToCopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
    private final String windowExecutionId;
    private final String taskExecutionId;
    private final String invocationId;
    private final String executionId;
    private final String parameters;
    private final String status;
    private final String statusDetails;
    private final Date startTime;
    private final Date endTime;
    private final String ownerInformation;
    private final String windowTargetId;

    private MaintenanceWindowExecutionTaskInvocationIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.invocationId = builder.invocationId;
        this.executionId = builder.executionId;
        this.parameters = builder.parameters;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ownerInformation = builder.ownerInformation;
        this.windowTargetId = builder.windowTargetId;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public String taskExecutionId() {
        return this.taskExecutionId;
    }

    public String invocationId() {
        return this.invocationId;
    }

    public String executionId() {
        return this.executionId;
    }

    public String parameters() {
        return this.parameters;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String windowTargetId() {
        return this.windowTargetId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutionId() == null ? 0 : this.windowExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.taskExecutionId() == null ? 0 : this.taskExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.invocationId() == null ? 0 : this.invocationId().hashCode());
        hashCode = 31 * hashCode + (this.executionId() == null ? 0 : this.executionId().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.ownerInformation() == null ? 0 : this.ownerInformation().hashCode());
        hashCode = 31 * hashCode + (this.windowTargetId() == null ? 0 : this.windowTargetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskInvocationIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskInvocationIdentity other = (MaintenanceWindowExecutionTaskInvocationIdentity)obj;
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskExecutionId() == null ^ this.taskExecutionId() == null) {
            return false;
        }
        if (other.taskExecutionId() != null && !other.taskExecutionId().equals(this.taskExecutionId())) {
            return false;
        }
        if (other.invocationId() == null ^ this.invocationId() == null) {
            return false;
        }
        if (other.invocationId() != null && !other.invocationId().equals(this.invocationId())) {
            return false;
        }
        if (other.executionId() == null ^ this.executionId() == null) {
            return false;
        }
        if (other.executionId() != null && !other.executionId().equals(this.executionId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.ownerInformation() == null ^ this.ownerInformation() == null) {
            return false;
        }
        if (other.ownerInformation() != null && !other.ownerInformation().equals(this.ownerInformation())) {
            return false;
        }
        if (other.windowTargetId() == null ^ this.windowTargetId() == null) {
            return false;
        }
        return other.windowTargetId() == null || other.windowTargetId().equals(this.windowTargetId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskExecutionId() != null) {
            sb.append("TaskExecutionId: ").append(this.taskExecutionId()).append(",");
        }
        if (this.invocationId() != null) {
            sb.append("InvocationId: ").append(this.invocationId()).append(",");
        }
        if (this.executionId() != null) {
            sb.append("ExecutionId: ").append(this.executionId()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.ownerInformation() != null) {
            sb.append("OwnerInformation: ").append(this.ownerInformation()).append(",");
        }
        if (this.windowTargetId() != null) {
            sb.append("WindowTargetId: ").append(this.windowTargetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MaintenanceWindowExecutionTaskInvocationIdentityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private String taskExecutionId;
        private String invocationId;
        private String executionId;
        private String parameters;
        private String status;
        private String statusDetails;
        private Date startTime;
        private Date endTime;
        private String ownerInformation;
        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskInvocationIdentity model) {
            this.setWindowExecutionId(model.windowExecutionId);
            this.setTaskExecutionId(model.taskExecutionId);
            this.setInvocationId(model.invocationId);
            this.setExecutionId(model.executionId);
            this.setParameters(model.parameters);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setOwnerInformation(model.ownerInformation);
            this.setWindowTargetId(model.windowTargetId);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return this.taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getInvocationId() {
            return this.invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getWindowTargetId() {
            return this.windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        public MaintenanceWindowExecutionTaskInvocationIdentity build() {
            return new MaintenanceWindowExecutionTaskInvocationIdentity(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
        public Builder windowExecutionId(String var1);

        public Builder taskExecutionId(String var1);

        public Builder invocationId(String var1);

        public Builder executionId(String var1);

        public Builder parameters(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder ownerInformation(String var1);

        public Builder windowTargetId(String var1);
    }
}

