/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ssm.model.Parameter;
import software.amazon.awssdk.services.ssm.model.ParameterListCopier;
import software.amazon.awssdk.services.ssm.model.ParameterNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetParametersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetParametersResponse> {
    private final List<Parameter> parameters;
    private final List<String> invalidParameters;

    private GetParametersResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.invalidParameters = builder.invalidParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<String> invalidParameters() {
        return this.invalidParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.invalidParameters() == null ? 0 : this.invalidParameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersResponse)) {
            return false;
        }
        GetParametersResponse other = (GetParametersResponse)((Object)obj);
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.invalidParameters() == null ^ this.invalidParameters() == null) {
            return false;
        }
        return other.invalidParameters() == null || other.invalidParameters().equals(this.invalidParameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.invalidParameters() != null) {
            sb.append("InvalidParameters: ").append(this.invalidParameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Parameter> parameters = new SdkInternalList();
        private List<String> invalidParameters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersResponse model) {
            this.setParameters(model.parameters);
            this.setInvalidParameters(model.invalidParameters);
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParameterListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Collection<String> getInvalidParameters() {
            return this.invalidParameters;
        }

        @Override
        public final Builder invalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidParameters(String ... invalidParameters) {
            if (this.invalidParameters == null) {
                this.invalidParameters = new SdkInternalList(invalidParameters.length);
            }
            for (String e : invalidParameters) {
                this.invalidParameters.add(e);
            }
            return this;
        }

        public final void setInvalidParameters(Collection<String> invalidParameters) {
            this.invalidParameters = ParameterNameListCopier.copy(invalidParameters);
        }

        @SafeVarargs
        public final void setInvalidParameters(String ... invalidParameters) {
            if (this.invalidParameters == null) {
                this.invalidParameters = new SdkInternalList(invalidParameters.length);
            }
            for (String e : invalidParameters) {
                this.invalidParameters.add(e);
            }
        }

        public GetParametersResponse build() {
            return new GetParametersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetParametersResponse> {
        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder invalidParameters(Collection<String> var1);

        public Builder invalidParameters(String ... var1);
    }
}

