/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionTaskIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMaintenanceWindowExecutionResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
    private final String windowExecutionId;
    private final List<String> taskIds;
    private final String status;
    private final String statusDetails;
    private final Date startTime;
    private final Date endTime;

    private GetMaintenanceWindowExecutionResponse(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskIds = builder.taskIds;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String windowExecutionId() {
        return this.windowExecutionId;
    }

    public List<String> taskIds() {
        return this.taskIds;
    }

    public String status() {
        return this.status;
    }

    public String statusDetails() {
        return this.statusDetails;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.windowExecutionId() == null ? 0 : this.windowExecutionId().hashCode());
        hashCode = 31 * hashCode + (this.taskIds() == null ? 0 : this.taskIds().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.statusDetails() == null ? 0 : this.statusDetails().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowExecutionResponse)) {
            return false;
        }
        GetMaintenanceWindowExecutionResponse other = (GetMaintenanceWindowExecutionResponse)((Object)obj);
        if (other.windowExecutionId() == null ^ this.windowExecutionId() == null) {
            return false;
        }
        if (other.windowExecutionId() != null && !other.windowExecutionId().equals(this.windowExecutionId())) {
            return false;
        }
        if (other.taskIds() == null ^ this.taskIds() == null) {
            return false;
        }
        if (other.taskIds() != null && !other.taskIds().equals(this.taskIds())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.statusDetails() == null ^ this.statusDetails() == null) {
            return false;
        }
        if (other.statusDetails() != null && !other.statusDetails().equals(this.statusDetails())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        return other.endTime() == null || other.endTime().equals(this.endTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.windowExecutionId() != null) {
            sb.append("WindowExecutionId: ").append(this.windowExecutionId()).append(",");
        }
        if (this.taskIds() != null) {
            sb.append("TaskIds: ").append(this.taskIds()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.statusDetails() != null) {
            sb.append("StatusDetails: ").append(this.statusDetails()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String windowExecutionId;
        private List<String> taskIds = new SdkInternalList();
        private String status;
        private String statusDetails;
        private Date startTime;
        private Date endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowExecutionResponse model) {
            this.setWindowExecutionId(model.windowExecutionId);
            this.setTaskIds(model.taskIds);
            this.setStatus(model.status);
            this.setStatusDetails(model.statusDetails);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final Collection<String> getTaskIds() {
            return this.taskIds;
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String ... taskIds) {
            if (this.taskIds == null) {
                this.taskIds = new SdkInternalList(taskIds.length);
            }
            for (String e : taskIds) {
                this.taskIds.add(e);
            }
            return this;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = MaintenanceWindowExecutionTaskIdListCopier.copy(taskIds);
        }

        @SafeVarargs
        public final void setTaskIds(String ... taskIds) {
            if (this.taskIds == null) {
                this.taskIds = new SdkInternalList(taskIds.length);
            }
            for (String e : taskIds) {
                this.taskIds.add(e);
            }
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(MaintenanceWindowExecutionStatus status) {
            this.status(status.toString());
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public GetMaintenanceWindowExecutionResponse build() {
            return new GetMaintenanceWindowExecutionResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMaintenanceWindowExecutionResponse> {
        public Builder windowExecutionId(String var1);

        public Builder taskIds(Collection<String> var1);

        public Builder taskIds(String ... var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);
    }
}

