/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the <i>Amazon SQS API Reference</i>.
 * </p>
 * <p>
 * Amazon SQS is a reliable, highly-scalable hosted queue for storing messages as they travel between applications or
 * microservices. Amazon SQS moves data between distributed application components and helps you decouple these
 * components.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a href=
 * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-authentication-and-access-control.html"
 * >Identity and access management</a> in the <i>Amazon SQS Developer Guide.</i>
 * </p>
 * <p>
 * You can use <a href="http://aws.amazon.com/tools/#sdk">Amazon Web Services SDKs</a> to access Amazon SQS using your
 * favorite programming language. The SDKs perform tasks such as the following automatically:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Cryptographically sign your service requests
 * </p>
 * </li>
 * <li>
 * <p>
 * Retry requests
 * </p>
 * </li>
 * <li>
 * <p>
 * Handle error responses
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>Additional information</b>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/sqs/">Amazon SQS Product Page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>Amazon SQS Developer Guide</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html">
 * Making API Requests</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-message-metadata.html#sqs-message-attributes"
 * >Amazon SQS Message Attributes</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html">
 * Amazon SQS Dead-Letter Queues</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * <a href="https://awscli.amazonaws.com/v2/documentation/api/latest/reference/sqs/index.html">Amazon SQS in the Command
 * Line Interface</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>Amazon Web Services General Reference</i>
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#sqs_region">Regions and Endpoints</a>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Hello_section.html"
 * target="_top">Hello Amazon SQS</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_CreateQueue_section.html"
 * target="_top">Use CreateQueue</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_GetQueueUrl_section.html"
 * target="_top">Use GetQueueUrl</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_ListQueues_section.html"
 * target="_top">Use ListQueues</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_DeleteQueue_section.html"
 * target="_top">Use DeleteQueue</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_SendMessage_section.html"
 * target="_top">Use SendMessage</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_SendMessageBatch_section.html"
 * target="_top">Use SendMessageBatch</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_ReceiveMessage_section.html"
 * target="_top">Use ReceiveMessage</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_DeleteMessage_section.html"
 * target="_top">Use DeleteMessage</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_SetQueueAttributes_section.html"
 * target="_top">Use SetQueueAttributes</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_s3_Scenario_ProcessS3EventNotification_section.html"
 * target="_top">Receive and process Amazon S3 event notifications by using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_cross_SQSMessageApp_section.html"
 * target="_top">Create a web application that sends and retrieves messages by using Amazon SQS</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_cross_RekognitionVideoDetection_section.html"
 * target="_top">Detect people and objects in a video with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Scenario_SendReceiveBatch_section.html"
 * target="_top">Send and receive batches of messages with Amazon SQS using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Scenario_TopicsAndQueues_section.html"
 * target="_top">Publish Amazon SNS messages to Amazon SQS queues using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Scenario_WorkWithTags_section.html"
 * target="_top">Work with queue tags and Amazon SQS using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Scenario_UseJMS_section.html"
 * target="_top">Use the Amazon SQS Java Messaging Library to work with the Java Message Service (JMS) interface for
 * Amazon SQS</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sqs_Scenario_SqsExtendedClient_section.html"
 * target="_top">Manage large Amazon SQS messages using Amazon S3 with an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_sns_PublishFifoTopic_section.html"
 * target="_top">Create and publish to a FIFO Amazon SNS topic using an AWS SDK</a></li>
 * </ul>
 * <h3>Serverless Examples</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_serverless_SQS_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon SQS trigger</a></li>
 * <li><a href=
 * "https://docs.aws.amazon.com/code-library/latest/ug/sqs_example_serverless_SQS_Lambda_batch_item_failures_section.html"
 * target="_top">Reporting batch item failures for Lambda functions with an Amazon SQS trigger</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.sqs;