/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.time.Duration;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.batchmanager.BatchOverrideConfiguration;

@SdkInternalApi
public final class RequestBatchConfiguration {
    public static final int DEFAULT_MAX_BATCH_ITEMS = 10;
    public static final int DEFAULT_MAX_BATCH_BYTES_SIZE = -1;
    public static final int DEFAULT_MAX_BATCH_KEYS = 10000;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 500;
    public static final Duration DEFAULT_MAX_BATCH_OPEN_IN_MS = Duration.ofMillis(200L);
    private final Integer maxBatchItems;
    private final Integer maxBatchKeys;
    private final Integer maxBufferSize;
    private final Duration sendRequestFrequency;
    private final Integer maxBatchBytesSize;

    private RequestBatchConfiguration(Builder builder) {
        this.maxBatchItems = builder.maxBatchItems != null ? builder.maxBatchItems : 10;
        this.maxBatchKeys = builder.maxBatchKeys != null ? builder.maxBatchKeys : 10000;
        this.maxBufferSize = builder.maxBufferSize != null ? builder.maxBufferSize : 500;
        this.sendRequestFrequency = builder.sendRequestFrequency != null ? builder.sendRequestFrequency : DEFAULT_MAX_BATCH_OPEN_IN_MS;
        this.maxBatchBytesSize = builder.maxBatchBytesSize != null ? builder.maxBatchBytesSize : -1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BatchOverrideConfiguration configuration) {
        if (configuration != null) {
            return new Builder().maxBatchItems(configuration.maxBatchSize()).sendRequestFrequency(configuration.sendRequestFrequency()).maxBatchBytesSize(configuration.maxBatchSize());
        }
        return new Builder();
    }

    public Duration sendRequestFrequency() {
        return this.sendRequestFrequency;
    }

    public int maxBatchItems() {
        return this.maxBatchItems;
    }

    public int maxBatchKeys() {
        return this.maxBatchKeys;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public int maxBatchBytesSize() {
        return this.maxBatchBytesSize;
    }

    public static final class Builder {
        private Integer maxBatchItems;
        private Integer maxBatchKeys;
        private Integer maxBufferSize;
        private Duration sendRequestFrequency;
        private Integer maxBatchBytesSize;

        private Builder() {
        }

        public Builder maxBatchItems(Integer maxBatchItems) {
            this.maxBatchItems = maxBatchItems;
            return this;
        }

        public Builder maxBatchKeys(Integer maxBatchKeys) {
            this.maxBatchKeys = maxBatchKeys;
            return this;
        }

        public Builder maxBufferSize(Integer maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Builder sendRequestFrequency(Duration sendRequestFrequency) {
            this.sendRequestFrequency = sendRequestFrequency;
            return this;
        }

        public Builder maxBatchBytesSize(Integer maxBatchBytesSize) {
            this.maxBatchBytesSize = maxBatchBytesSize;
            return this;
        }

        public RequestBatchConfiguration build() {
            return new RequestBatchConfiguration(this);
        }
    }
}

