/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddPermissionRequest extends SqsRequest implements
        ToCopyableBuilder<AddPermissionRequest.Builder, AddPermissionRequest> {
    private static final SdkField<String> QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueUrl").getter(getter(AddPermissionRequest::queueUrl)).setter(setter(Builder::queueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueUrl").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(AddPermissionRequest::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<List<String>> AWS_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AWSAccountIds")
            .getter(getter(AddPermissionRequest::awsAccountIds))
            .setter(setter(Builder::awsAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(AddPermissionRequest::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_URL_FIELD, LABEL_FIELD,
            AWS_ACCOUNT_IDS_FIELD, ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queueUrl;

    private final String label;

    private final List<String> awsAccountIds;

    private final List<String> actions;

    private AddPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.label = builder.label;
        this.awsAccountIds = builder.awsAccountIds;
        this.actions = builder.actions;
    }

    /**
     * <p>
     * The URL of the Amazon SQS queue to which permissions are added.
     * </p>
     * <p>
     * Queue URLs and names are case-sensitive.
     * </p>
     * 
     * @return The URL of the Amazon SQS queue to which permissions are added.</p>
     *         <p>
     *         Queue URLs and names are case-sensitive.
     */
    public final String queueUrl() {
        return queueUrl;
    }

    /**
     * <p>
     * The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>). Maximum
     * 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and underscores (
     * <code>_</code>).
     * </p>
     * 
     * @return The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>).
     *         Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and
     *         underscores (<code>_</code>).
     */
    public final String label() {
        return label;
    }

    /**
     * For responses, this returns true if the service returned a value for the AWSAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsAccountIds() {
        return awsAccountIds != null && !(awsAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services account numbers of the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
     * permission. For information about locating the Amazon Web Services account identification, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
     * >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsAccountIds} method.
     * </p>
     * 
     * @return The Amazon Web Services account numbers of the <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
     *         permission. For information about locating the Amazon Web Services account identification, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
     *         >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
     */
    public final List<String> awsAccountIds() {
        return awsAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action the client wants to allow for the specified principal. Valid values: the name of any action or
     * <code>*</code>.
     * </p>
     * <p>
     * For more information about these actions, see <a href=
     * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
     * >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the <i>Amazon SQS
     * Developer Guide</i>.
     * </p>
     * <p>
     * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
     * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
     * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return The action the client wants to allow for the specified principal. Valid values: the name of any action or
     *         <code>*</code>.</p>
     *         <p>
     *         For more information about these actions, see <a href=
     *         "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
     *         >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the
     *         <i>Amazon SQS Developer Guide</i>.
     *         </p>
     *         <p>
     *         Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code>
     *         for <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those
     *         actions: <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and
     *         <code>ChangeMessageVisibilityBatch</code>.
     */
    public final List<String> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsAccountIds() ? awsAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest) obj;
        return Objects.equals(queueUrl(), other.queueUrl()) && Objects.equals(label(), other.label())
                && hasAwsAccountIds() == other.hasAwsAccountIds() && Objects.equals(awsAccountIds(), other.awsAccountIds())
                && hasActions() == other.hasActions() && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddPermissionRequest").add("QueueUrl", queueUrl()).add("Label", label())
                .add("AWSAccountIds", hasAwsAccountIds() ? awsAccountIds() : null)
                .add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueueUrl":
            return Optional.ofNullable(clazz.cast(queueUrl()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "AWSAccountIds":
            return Optional.ofNullable(clazz.cast(awsAccountIds()));
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueueUrl", QUEUE_URL_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("AWSAccountIds", AWS_ACCOUNT_IDS_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddPermissionRequest, T> g) {
        return obj -> g.apply((AddPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SqsRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddPermissionRequest> {
        /**
         * <p>
         * The URL of the Amazon SQS queue to which permissions are added.
         * </p>
         * <p>
         * Queue URLs and names are case-sensitive.
         * </p>
         * 
         * @param queueUrl
         *        The URL of the Amazon SQS queue to which permissions are added.</p>
         *        <p>
         *        Queue URLs and names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueUrl(String queueUrl);

        /**
         * <p>
         * The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>).
         * Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>), and
         * underscores (<code>_</code>).
         * </p>
         * 
         * @param label
         *        The unique identification of the permission you're setting (for example, <code>AliceSendMessage</code>
         *        ). Maximum 80 characters. Allowed characters include alphanumeric characters, hyphens (<code>-</code>
         *        ), and underscores (<code>_</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * The Amazon Web Services account numbers of the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
         * permission. For information about locating the Amazon Web Services account identification, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
         * >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account numbers of the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to
         *        receive permission. For information about locating the Amazon Web Services account identification, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
         *        >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(Collection<String> awsAccountIds);

        /**
         * <p>
         * The Amazon Web Services account numbers of the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to receive
         * permission. For information about locating the Amazon Web Services account identification, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
         * >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * </p>
         * 
         * @param awsAccountIds
         *        The Amazon Web Services account numbers of the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/glos-chap.html#P">principals</a> who are to
         *        receive permission. For information about locating the Amazon Web Services account identification, see
         *        <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-making-api-requests.html#sqs-api-request-authentication"
         *        >Your Amazon Web Services Identifiers</a> in the <i>Amazon SQS Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountIds(String... awsAccountIds);

        /**
         * <p>
         * The action the client wants to allow for the specified principal. Valid values: the name of any action or
         * <code>*</code>.
         * </p>
         * <p>
         * For more information about these actions, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
         * >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the <i>Amazon
         * SQS Developer Guide</i>.
         * </p>
         * <p>
         * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
         * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
         * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>
         * .
         * </p>
         * 
         * @param actions
         *        The action the client wants to allow for the specified principal. Valid values: the name of any action
         *        or <code>*</code>.</p>
         *        <p>
         *        For more information about these actions, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
         *        >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the
         *        <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or
         *        <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the
         *        corresponding batch versions of those actions: <code>SendMessageBatch</code>,
         *        <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The action the client wants to allow for the specified principal. Valid values: the name of any action or
         * <code>*</code>.
         * </p>
         * <p>
         * For more information about these actions, see <a href=
         * "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
         * >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the <i>Amazon
         * SQS Developer Guide</i>.
         * </p>
         * <p>
         * Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or <code>ChangeMessageVisibility</code> for
         * <code>ActionName.n</code> also grants permissions for the corresponding batch versions of those actions:
         * <code>SendMessageBatch</code>, <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>
         * .
         * </p>
         * 
         * @param actions
         *        The action the client wants to allow for the specified principal. Valid values: the name of any action
         *        or <code>*</code>.</p>
         *        <p>
         *        For more information about these actions, see <a href=
         *        "https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-overview-of-managing-access.html"
         *        >Overview of Managing Access Permissions to Your Amazon Simple Queue Service Resource</a> in the
         *        <i>Amazon SQS Developer Guide</i>.
         *        </p>
         *        <p>
         *        Specifying <code>SendMessage</code>, <code>DeleteMessage</code>, or
         *        <code>ChangeMessageVisibility</code> for <code>ActionName.n</code> also grants permissions for the
         *        corresponding batch versions of those actions: <code>SendMessageBatch</code>,
         *        <code>DeleteMessageBatch</code>, and <code>ChangeMessageVisibilityBatch</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SqsRequest.BuilderImpl implements Builder {
        private String queueUrl;

        private String label;

        private List<String> awsAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddPermissionRequest model) {
            super(model);
            queueUrl(model.queueUrl);
            label(model.label);
            awsAccountIds(model.awsAccountIds);
            actions(model.actions);
        }

        public final String getQueueUrl() {
            return queueUrl;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Collection<String> getAwsAccountIds() {
            if (awsAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return awsAccountIds;
        }

        public final void setAwsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
        }

        @Override
        public final Builder awsAccountIds(Collection<String> awsAccountIds) {
            this.awsAccountIds = AWSAccountIdListCopier.copy(awsAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsAccountIds(String... awsAccountIds) {
            awsAccountIds(Arrays.asList(awsAccountIds));
            return this;
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionNameListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddPermissionRequest build() {
            return new AddPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
