/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueueAttributesResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, GetQueueAttributesResponse> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(GetQueueAttributesResponse.getter(GetQueueAttributesResponse::attributesAsStrings)).setter(GetQueueAttributesResponse.setter(Builder::attributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).isFlattened(true).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Attributes", ATTRIBUTES_FIELD);
        }
    });
    private final Map<String, String> attributes;

    private GetQueueAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.attributes = builder.attributes;
    }

    public final Map<QueueAttributeName, String> attributes() {
        return QueueAttributeMapCopier.copyStringToEnum(this.attributes);
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueueAttributesResponse)) {
            return false;
        }
        GetQueueAttributesResponse other = (GetQueueAttributesResponse)((Object)obj);
        return this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueueAttributesResponse").add("Attributes", this.hasAttributes() ? this.attributesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueueAttributesResponse, T> g) {
        return obj -> g.apply((GetQueueAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueueAttributesResponse model) {
            super(model);
            this.attributesWithStrings(model.attributes);
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<QueueAttributeName, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copyEnumToString(attributes);
            return this;
        }

        @Override
        public GetQueueAttributesResponse build() {
            return new GetQueueAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueueAttributesResponse> {
        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<QueueAttributeName, String> var1);
    }
}

