/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sqs.model.SqsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendMessageResponse
extends SqsResponse
implements ToCopyableBuilder<Builder, SendMessageResponse> {
    private static final SdkField<String> MD5_OF_MESSAGE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5OfMessageBody").getter(SendMessageResponse.getter(SendMessageResponse::md5OfMessageBody)).setter(SendMessageResponse.setter(Builder::md5OfMessageBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageBody").build()}).build();
    private static final SdkField<String> MD5_OF_MESSAGE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5OfMessageAttributes").getter(SendMessageResponse.getter(SendMessageResponse::md5OfMessageAttributes)).setter(SendMessageResponse.setter(Builder::md5OfMessageAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageAttributes").build()}).build();
    private static final SdkField<String> MD5_OF_MESSAGE_SYSTEM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MD5OfMessageSystemAttributes").getter(SendMessageResponse.getter(SendMessageResponse::md5OfMessageSystemAttributes)).setter(SendMessageResponse.setter(Builder::md5OfMessageSystemAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MD5OfMessageSystemAttributes").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(SendMessageResponse.getter(SendMessageResponse::messageId)).setter(SendMessageResponse.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<String> SEQUENCE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SequenceNumber").getter(SendMessageResponse.getter(SendMessageResponse::sequenceNumber)).setter(SendMessageResponse.setter(Builder::sequenceNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MD5_OF_MESSAGE_BODY_FIELD, MD5_OF_MESSAGE_ATTRIBUTES_FIELD, MD5_OF_MESSAGE_SYSTEM_ATTRIBUTES_FIELD, MESSAGE_ID_FIELD, SEQUENCE_NUMBER_FIELD));
    private final String md5OfMessageBody;
    private final String md5OfMessageAttributes;
    private final String md5OfMessageSystemAttributes;
    private final String messageId;
    private final String sequenceNumber;

    private SendMessageResponse(BuilderImpl builder) {
        super(builder);
        this.md5OfMessageBody = builder.md5OfMessageBody;
        this.md5OfMessageAttributes = builder.md5OfMessageAttributes;
        this.md5OfMessageSystemAttributes = builder.md5OfMessageSystemAttributes;
        this.messageId = builder.messageId;
        this.sequenceNumber = builder.sequenceNumber;
    }

    public String md5OfMessageBody() {
        return this.md5OfMessageBody;
    }

    public String md5OfMessageAttributes() {
        return this.md5OfMessageAttributes;
    }

    public String md5OfMessageSystemAttributes() {
        return this.md5OfMessageSystemAttributes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5OfMessageSystemAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageResponse)) {
            return false;
        }
        SendMessageResponse other = (SendMessageResponse)((Object)obj);
        return Objects.equals(this.md5OfMessageBody(), other.md5OfMessageBody()) && Objects.equals(this.md5OfMessageAttributes(), other.md5OfMessageAttributes()) && Objects.equals(this.md5OfMessageSystemAttributes(), other.md5OfMessageSystemAttributes()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageResponse").add("MD5OfMessageBody", (Object)this.md5OfMessageBody()).add("MD5OfMessageAttributes", (Object)this.md5OfMessageAttributes()).add("MD5OfMessageSystemAttributes", (Object)this.md5OfMessageSystemAttributes()).add("MessageId", (Object)this.messageId()).add("SequenceNumber", (Object)this.sequenceNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MD5OfMessageBody": {
                return Optional.ofNullable(clazz.cast(this.md5OfMessageBody()));
            }
            case "MD5OfMessageAttributes": {
                return Optional.ofNullable(clazz.cast(this.md5OfMessageAttributes()));
            }
            case "MD5OfMessageSystemAttributes": {
                return Optional.ofNullable(clazz.cast(this.md5OfMessageSystemAttributes()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageResponse, T> g) {
        return obj -> g.apply((SendMessageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SqsResponse.BuilderImpl
    implements Builder {
        private String md5OfMessageBody;
        private String md5OfMessageAttributes;
        private String md5OfMessageSystemAttributes;
        private String messageId;
        private String sequenceNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageResponse model) {
            super(model);
            this.md5OfMessageBody(model.md5OfMessageBody);
            this.md5OfMessageAttributes(model.md5OfMessageAttributes);
            this.md5OfMessageSystemAttributes(model.md5OfMessageSystemAttributes);
            this.messageId(model.messageId);
            this.sequenceNumber(model.sequenceNumber);
        }

        public final String getMd5OfMessageBody() {
            return this.md5OfMessageBody;
        }

        @Override
        public final Builder md5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
            return this;
        }

        public final void setMd5OfMessageBody(String md5OfMessageBody) {
            this.md5OfMessageBody = md5OfMessageBody;
        }

        public final String getMd5OfMessageAttributes() {
            return this.md5OfMessageAttributes;
        }

        @Override
        public final Builder md5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
            return this;
        }

        public final void setMd5OfMessageAttributes(String md5OfMessageAttributes) {
            this.md5OfMessageAttributes = md5OfMessageAttributes;
        }

        public final String getMd5OfMessageSystemAttributes() {
            return this.md5OfMessageSystemAttributes;
        }

        @Override
        public final Builder md5OfMessageSystemAttributes(String md5OfMessageSystemAttributes) {
            this.md5OfMessageSystemAttributes = md5OfMessageSystemAttributes;
            return this;
        }

        public final void setMd5OfMessageSystemAttributes(String md5OfMessageSystemAttributes) {
            this.md5OfMessageSystemAttributes = md5OfMessageSystemAttributes;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        @Override
        public SendMessageResponse build() {
            return new SendMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SqsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendMessageResponse> {
        public Builder md5OfMessageBody(String var1);

        public Builder md5OfMessageAttributes(String var1);

        public Builder md5OfMessageSystemAttributes(String var1);

        public Builder messageId(String var1);

        public Builder sequenceNumber(String var1);
    }
}

