/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessageBatchRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, SendMessageBatchRequest> {
    private final String queueUrl;
    private final List<SendMessageBatchRequestEntry> entries;

    private SendMessageBatchRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<SendMessageBatchRequestEntry> entries() {
        return this.entries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.entries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageBatchRequest)) {
            return false;
        }
        SendMessageBatchRequest other = (SendMessageBatchRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.entries(), other.entries());
    }

    public String toString() {
        return ToString.builder((String)"SendMessageBatchRequest").add("QueueUrl", (Object)this.queueUrl()).add("Entries", this.entries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "Entries": {
                return Optional.of(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<SendMessageBatchRequestEntry> entries;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageBatchRequest model) {
            this.queueUrl(model.queueUrl);
            this.entries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<SendMessageBatchRequestEntry.Builder> getEntries() {
            return this.entries != null ? (Collection)this.entries.stream().map(SendMessageBatchRequestEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder entries(Collection<SendMessageBatchRequestEntry> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(SendMessageBatchRequestEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<SendMessageBatchRequestEntry.BuilderImpl> entries) {
            this.entries = SendMessageBatchRequestEntryListCopier.copyFromBuilder(entries);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendMessageBatchRequest build() {
            return new SendMessageBatchRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, SendMessageBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<SendMessageBatchRequestEntry> var1);

        public Builder entries(SendMessageBatchRequestEntry ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

