/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.StaxResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.SQSClient;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.BatchEntryIdsNotDistinctException;
import software.amazon.awssdk.services.sqs.model.BatchRequestTooLongException;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.EmptyBatchRequestException;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.InvalidAttributeNameException;
import software.amazon.awssdk.services.sqs.model.InvalidBatchEntryIdException;
import software.amazon.awssdk.services.sqs.model.InvalidIdFormatException;
import software.amazon.awssdk.services.sqs.model.InvalidMessageContentsException;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsRequest;
import software.amazon.awssdk.services.sqs.model.ListQueueTagsResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.MessageNotInflightException;
import software.amazon.awssdk.services.sqs.model.OverLimitException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueInProgressException;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.QueueDeletedRecentlyException;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;
import software.amazon.awssdk.services.sqs.model.QueueNameExistsException;
import software.amazon.awssdk.services.sqs.model.ReceiptHandleIsInvalidException;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SQSException;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.TagQueueRequest;
import software.amazon.awssdk.services.sqs.model.TagQueueResponse;
import software.amazon.awssdk.services.sqs.model.TooManyEntriesInBatchRequestException;
import software.amazon.awssdk.services.sqs.model.UnsupportedOperationException;
import software.amazon.awssdk.services.sqs.model.UntagQueueRequest;
import software.amazon.awssdk.services.sqs.model.UntagQueueResponse;
import software.amazon.awssdk.services.sqs.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.AddPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.BatchEntryIdsNotDistinctExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.BatchRequestTooLongExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.EmptyBatchRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidAttributeNameExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidBatchEntryIdExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidIdFormatExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidMessageContentsExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueueTagsRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueueTagsResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.MessageNotInflightExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.OverLimitExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueInProgressExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueDeletedRecentlyExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueDoesNotExistExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueNameExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiptHandleIsInvalidExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.TagQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.TagQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.TooManyEntriesInBatchRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.UnsupportedOperationExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.UntagQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.UntagQueueResponseUnmarshaller;

@SdkInternalApi
final class DefaultSQSClient
implements SQSClient {
    private final ClientHandler clientHandler;
    private final List<Unmarshaller<SdkServiceException, Node>> exceptionUnmarshallers;
    private final ClientConfiguration clientConfiguration;

    protected DefaultSQSClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.exceptionUnmarshallers = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public AddPermissionResponse addPermission(AddPermissionRequest addPermissionRequest) throws OverLimitException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddPermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (AddPermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)addPermissionRequest).withMarshaller((Marshaller)new AddPermissionRequestMarshaller()));
    }

    @Override
    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws MessageNotInflightException, ReceiptHandleIsInvalidException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ChangeMessageVisibilityResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)changeMessageVisibilityRequest).withMarshaller((Marshaller)new ChangeMessageVisibilityRequestMarshaller()));
    }

    @Override
    public ChangeMessageVisibilityBatchResponse changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, InvalidBatchEntryIdException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ChangeMessageVisibilityBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)changeMessageVisibilityBatchRequest).withMarshaller((Marshaller)new ChangeMessageVisibilityBatchRequestMarshaller()));
    }

    @Override
    public CreateQueueResponse createQueue(CreateQueueRequest createQueueRequest) throws QueueDeletedRecentlyException, QueueNameExistsException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (CreateQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)createQueueRequest).withMarshaller((Marshaller)new CreateQueueRequestMarshaller()));
    }

    @Override
    public DeleteMessageResponse deleteMessage(DeleteMessageRequest deleteMessageRequest) throws InvalidIdFormatException, ReceiptHandleIsInvalidException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteMessageRequest).withMarshaller((Marshaller)new DeleteMessageRequestMarshaller()));
    }

    @Override
    public DeleteMessageBatchResponse deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, InvalidBatchEntryIdException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteMessageBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteMessageBatchRequest).withMarshaller((Marshaller)new DeleteMessageBatchRequestMarshaller()));
    }

    @Override
    public DeleteQueueResponse deleteQueue(DeleteQueueRequest deleteQueueRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (DeleteQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)deleteQueueRequest).withMarshaller((Marshaller)new DeleteQueueRequestMarshaller()));
    }

    @Override
    public GetQueueAttributesResponse getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) throws InvalidAttributeNameException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetQueueAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getQueueAttributesRequest).withMarshaller((Marshaller)new GetQueueAttributesRequestMarshaller()));
    }

    @Override
    public GetQueueUrlResponse getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) throws QueueDoesNotExistException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueUrlResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (GetQueueUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)getQueueUrlRequest).withMarshaller((Marshaller)new GetQueueUrlRequestMarshaller()));
    }

    @Override
    public ListDeadLetterSourceQueuesResponse listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws QueueDoesNotExistException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDeadLetterSourceQueuesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListDeadLetterSourceQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listDeadLetterSourceQueuesRequest).withMarshaller((Marshaller)new ListDeadLetterSourceQueuesRequestMarshaller()));
    }

    @Override
    public ListQueueTagsResponse listQueueTags(ListQueueTagsRequest listQueueTagsRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListQueueTagsResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListQueueTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listQueueTagsRequest).withMarshaller((Marshaller)new ListQueueTagsRequestMarshaller()));
    }

    @Override
    public ListQueuesResponse listQueues(ListQueuesRequest listQueuesRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListQueuesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ListQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)listQueuesRequest).withMarshaller((Marshaller)new ListQueuesRequestMarshaller()));
    }

    @Override
    public PurgeQueueResponse purgeQueue(PurgeQueueRequest purgeQueueRequest) throws QueueDoesNotExistException, PurgeQueueInProgressException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PurgeQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (PurgeQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)purgeQueueRequest).withMarshaller((Marshaller)new PurgeQueueRequestMarshaller()));
    }

    @Override
    public ReceiveMessageResponse receiveMessage(ReceiveMessageRequest receiveMessageRequest) throws OverLimitException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ReceiveMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (ReceiveMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)receiveMessageRequest).withMarshaller((Marshaller)new ReceiveMessageRequestMarshaller()));
    }

    @Override
    public RemovePermissionResponse removePermission(RemovePermissionRequest removePermissionRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemovePermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (RemovePermissionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)removePermissionRequest).withMarshaller((Marshaller)new RemovePermissionRequestMarshaller()));
    }

    @Override
    public SendMessageResponse sendMessage(SendMessageRequest sendMessageRequest) throws InvalidMessageContentsException, UnsupportedOperationException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SendMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)sendMessageRequest).withMarshaller((Marshaller)new SendMessageRequestMarshaller()));
    }

    @Override
    public SendMessageBatchResponse sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) throws TooManyEntriesInBatchRequestException, EmptyBatchRequestException, BatchEntryIdsNotDistinctException, BatchRequestTooLongException, InvalidBatchEntryIdException, UnsupportedOperationException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SendMessageBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)sendMessageBatchRequest).withMarshaller((Marshaller)new SendMessageBatchRequestMarshaller()));
    }

    @Override
    public SetQueueAttributesResponse setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) throws InvalidAttributeNameException, SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetQueueAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (SetQueueAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)setQueueAttributesRequest).withMarshaller((Marshaller)new SetQueueAttributesRequestMarshaller()));
    }

    @Override
    public TagQueueResponse tagQueue(TagQueueRequest tagQueueRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new TagQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (TagQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)tagQueueRequest).withMarshaller((Marshaller)new TagQueueRequestMarshaller()));
    }

    @Override
    public UntagQueueResponse untagQueue(UntagQueueRequest untagQueueRequest) throws SdkServiceException, SdkClientException, SQSException {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new UntagQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (UntagQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((SdkRequest)untagQueueRequest).withMarshaller((Marshaller)new UntagQueueRequestMarshaller()));
    }

    private List<Unmarshaller<SdkServiceException, Node>> init() {
        ArrayList<Unmarshaller<SdkServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<SdkServiceException, Node>>();
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new PurgeQueueInProgressExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidAttributeNameExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new BatchEntryIdsNotDistinctExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new TooManyEntriesInBatchRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new BatchRequestTooLongExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new UnsupportedOperationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidIdFormatExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new OverLimitExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new QueueDoesNotExistExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new QueueNameExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new MessageNotInflightExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new ReceiptHandleIsInvalidExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidMessageContentsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new QueueDeletedRecentlyExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new EmptyBatchRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new InvalidBatchEntryIdExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<SdkServiceException, Node>)new StandardErrorUnmarshaller(SQSException.class));
        return unmarshallers;
    }

    public void close() {
        this.clientHandler.close();
    }
}

