/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;

public class ChangeMessageVisibilityBatchRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityBatchRequest>, ChangeMessageVisibilityBatchRequest> {
    public Request<ChangeMessageVisibilityBatchRequest> marshall(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        List<ChangeMessageVisibilityBatchRequestEntry> entriesList;
        if (changeMessageVisibilityBatchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeMessageVisibilityBatchRequest, "SQSClient");
        request.addParameter("Action", "ChangeMessageVisibilityBatch");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (changeMessageVisibilityBatchRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)changeMessageVisibilityBatchRequest.queueUrl()));
        }
        if ((entriesList = changeMessageVisibilityBatchRequest.entries()) != null) {
            if (!entriesList.isEmpty()) {
                int entriesListIndex = 1;
                for (ChangeMessageVisibilityBatchRequestEntry entriesListValue : entriesList) {
                    if (entriesListValue.id() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".Id", StringUtils.fromString((String)entriesListValue.id()));
                    }
                    if (entriesListValue.receiptHandle() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".ReceiptHandle", StringUtils.fromString((String)entriesListValue.receiptHandle()));
                    }
                    if (entriesListValue.visibilityTimeout() != null) {
                        request.addParameter("ChangeMessageVisibilityBatchRequestEntry." + entriesListIndex + ".VisibilityTimeout", StringUtils.fromInteger((Integer)entriesListValue.visibilityTimeout()));
                    }
                    ++entriesListIndex;
                }
            } else {
                request.addParameter("ChangeMessageVisibilityBatchRequestEntry", "");
            }
        }
        return request;
    }
}

