/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.annotation.ReviewBeforeRelease;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.interceptor.Context;
import software.amazon.awssdk.interceptor.ExecutionAttributes;
import software.amazon.awssdk.interceptor.ExecutionInterceptor;

@ReviewBeforeRelease(value="Do we still want to do this?")
public class QueueUrlInterceptor
implements ExecutionInterceptor {
    private static final String QUEUE_URL_PARAMETER = "QueueUrl";

    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        HashMap requestParams = new HashMap(request.getParameters());
        List queueUrlParam = (List)requestParams.get(QUEUE_URL_PARAMETER);
        if (queueUrlParam != null && !queueUrlParam.isEmpty()) {
            List queueUrlParameter = (List)requestParams.remove(QUEUE_URL_PARAMETER);
            String queueUrl = (String)queueUrlParameter.iterator().next();
            try {
                URI uri = new URI(queueUrl);
                SdkHttpFullRequest.Builder mutableRequest = (SdkHttpFullRequest.Builder)request.toBuilder();
                mutableRequest.resourcePath(uri.getPath());
                if (uri.getHost() != null) {
                    URI uriWithoutPath = new URI(uri.toString().replace(uri.getPath(), ""));
                    mutableRequest.endpoint(uriWithoutPath);
                }
                return (SdkHttpFullRequest)mutableRequest.build();
            }
            catch (URISyntaxException e) {
                throw new AmazonClientException("Unable to parse SQS queue URL '" + queueUrl + "'", (Throwable)e);
            }
        }
        return request;
    }
}

