/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.TagQueueRequest;

public class TagQueueRequestMarshaller
implements Marshaller<Request<TagQueueRequest>, TagQueueRequest> {
    public Request<TagQueueRequest> marshall(TagQueueRequest tagQueueRequest) {
        Map<String, String> tags;
        if (tagQueueRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)tagQueueRequest, "SqsClient");
        request.addParameter("Action", "TagQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagQueueRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)tagQueueRequest.queueUrl()));
        }
        if ((tags = tagQueueRequest.tags()) != null) {
            int tagsListIndex = 1;
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Tags." + tagsListIndex + ".Key", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Tags." + tagsListIndex + ".Value", StringConversion.fromString((String)entry.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

