/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        Map<String, MessageAttributeValue> messageAttributes;
        if (sendMessageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)sendMessageRequest, "SqsClient");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (sendMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)sendMessageRequest.queueUrl()));
        }
        if (sendMessageRequest.messageBody() != null) {
            request.addParameter("MessageBody", StringConversion.fromString((String)sendMessageRequest.messageBody()));
        }
        if (sendMessageRequest.delaySeconds() != null) {
            request.addParameter("DelaySeconds", StringConversion.fromInteger((Integer)sendMessageRequest.delaySeconds()));
        }
        if ((messageAttributes = sendMessageRequest.messageAttributes()) != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Name", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    if (entry.getValue().stringValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringValue", StringConversion.fromString((String)entry.getValue().stringValue()));
                    }
                    if (entry.getValue().binaryValue() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryValue", StringConversion.fromSdkBytes((SdkBytes)entry.getValue().binaryValue()));
                    }
                    if (entry.getValue().stringListValues().isEmpty() && !(entry.getValue().stringListValues() instanceof SdkAutoConstructList)) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue", "");
                    } else if (!entry.getValue().stringListValues().isEmpty() && !(entry.getValue().stringListValues() instanceof SdkAutoConstructList)) {
                        List<String> stringListValuesList = entry.getValue().stringListValues();
                        int stringListValuesListIndex = 1;
                        for (String stringListValuesListValue : stringListValuesList) {
                            if (stringListValuesListValue != null) {
                                request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.StringListValue." + stringListValuesListIndex, StringConversion.fromString((String)stringListValuesListValue));
                            }
                            ++stringListValuesListIndex;
                        }
                    }
                    if (entry.getValue().binaryListValues().isEmpty() && !(entry.getValue().binaryListValues() instanceof SdkAutoConstructList)) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue", "");
                    } else if (!entry.getValue().binaryListValues().isEmpty() && !(entry.getValue().binaryListValues() instanceof SdkAutoConstructList)) {
                        List<SdkBytes> binaryListValuesList = entry.getValue().binaryListValues();
                        int binaryListValuesListIndex = 1;
                        for (SdkBytes binaryListValuesListValue : binaryListValuesList) {
                            if (binaryListValuesListValue != null) {
                                request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.BinaryListValue." + binaryListValuesListIndex, StringConversion.fromSdkBytes((SdkBytes)binaryListValuesListValue));
                            }
                            ++binaryListValuesListIndex;
                        }
                    }
                    if (entry.getValue().dataType() != null) {
                        request.addParameter("MessageAttribute." + messageAttributesListIndex + ".Value.DataType", StringConversion.fromString((String)entry.getValue().dataType()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        if (sendMessageRequest.messageDeduplicationId() != null) {
            request.addParameter("MessageDeduplicationId", StringConversion.fromString((String)sendMessageRequest.messageDeduplicationId()));
        }
        if (sendMessageRequest.messageGroupId() != null) {
            request.addParameter("MessageGroupId", StringConversion.fromString((String)sendMessageRequest.messageGroupId()));
        }
        return request;
    }
}

