/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;

public class DeleteMessageRequestMarshaller
implements Marshaller<Request<DeleteMessageRequest>, DeleteMessageRequest> {
    public Request<DeleteMessageRequest> marshall(DeleteMessageRequest deleteMessageRequest) {
        if (deleteMessageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteMessageRequest, "SqsClient");
        request.addParameter("Action", "DeleteMessage");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteMessageRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringConversion.fromString((String)deleteMessageRequest.queueUrl()));
        }
        if (deleteMessageRequest.receiptHandle() != null) {
            request.addParameter("ReceiptHandle", StringConversion.fromString((String)deleteMessageRequest.receiptHandle()));
        }
        return request;
    }
}

