/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SqsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQueueRequest
extends SqsRequest
implements ToCopyableBuilder<Builder, CreateQueueRequest> {
    private final String queueName;
    private final Map<String, String> attributes;

    private CreateQueueRequest(BuilderImpl builder) {
        super(builder);
        this.queueName = builder.queueName;
        this.attributes = builder.attributes;
    }

    public String queueName() {
        return this.queueName;
    }

    public Map<QueueAttributeName, String> attributes() {
        return TypeConverter.convert(this.attributes, QueueAttributeName::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)QueueAttributeName.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, String> attributesAsStrings() {
        return this.attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQueueRequest)) {
            return false;
        }
        CreateQueueRequest other = (CreateQueueRequest)((Object)obj);
        return Objects.equals(this.queueName(), other.queueName()) && Objects.equals(this.attributesAsStrings(), other.attributesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"CreateQueueRequest").add("QueueName", (Object)this.queueName()).add("Attributes", this.attributesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueName": {
                return Optional.ofNullable(clazz.cast(this.queueName()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SqsRequest.BuilderImpl
    implements Builder {
        private String queueName;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQueueRequest model) {
            super(model);
            this.queueName(model.queueName);
            this.attributesWithStrings(model.attributes);
        }

        public final String getQueueName() {
            return this.queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<QueueAttributeName, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateQueueRequest build() {
            return new CreateQueueRequest(this);
        }
    }

    public static interface Builder
    extends SqsRequest.Builder,
    CopyableBuilder<Builder, CreateQueueRequest> {
        public Builder queueName(String var1);

        public Builder attributesWithStrings(Map<String, String> var1);

        public Builder attributes(Map<QueueAttributeName, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

