/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;

public class GetQueueAttributesRequestMarshaller
implements Marshaller<Request<GetQueueAttributesRequest>, GetQueueAttributesRequest> {
    public Request<GetQueueAttributesRequest> marshall(GetQueueAttributesRequest getQueueAttributesRequest) {
        List<String> attributeNamesList;
        if (getQueueAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getQueueAttributesRequest, "SQSClient");
        request.addParameter("Action", "GetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (getQueueAttributesRequest.queueUrl() != null) {
            request.addParameter("QueueUrl", StringUtils.fromString((String)getQueueAttributesRequest.queueUrl()));
        }
        if ((attributeNamesList = getQueueAttributesRequest.attributeNamesAsStrings()) != null) {
            if (!attributeNamesList.isEmpty()) {
                int attributeNamesListIndex = 1;
                for (String attributeNamesListValue : attributeNamesList) {
                    if (attributeNamesListValue != null) {
                        request.addParameter("AttributeName." + attributeNamesListIndex, StringUtils.fromString((String)attributeNamesListValue));
                    }
                    ++attributeNamesListIndex;
                }
            } else {
                request.addParameter("AttributeName", "");
            }
        }
        return request;
    }
}

