/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.sqs.model.BinaryListCopier;
import software.amazon.awssdk.services.sqs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageAttributeValue
implements ToCopyableBuilder<Builder, MessageAttributeValue> {
    private final String stringValue;
    private final ByteBuffer binaryValue;
    private final List<String> stringListValues;
    private final List<ByteBuffer> binaryListValues;
    private final String dataType;

    private MessageAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.stringListValues = builder.stringListValues;
        this.binaryListValues = builder.binaryListValues;
        this.dataType = builder.dataType;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public ByteBuffer binaryValue() {
        return this.binaryValue == null ? null : this.binaryValue.asReadOnlyBuffer();
    }

    public List<String> stringListValues() {
        return this.stringListValues;
    }

    public List<ByteBuffer> binaryListValues() {
        return this.binaryListValues;
    }

    public String dataType() {
        return this.dataType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringListValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryListValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageAttributeValue)) {
            return false;
        }
        MessageAttributeValue other = (MessageAttributeValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.binaryValue(), other.binaryValue()) && Objects.equals(this.stringListValues(), other.stringListValues()) && Objects.equals(this.binaryListValues(), other.binaryListValues()) && Objects.equals(this.dataType(), other.dataType());
    }

    public String toString() {
        return ToString.builder((String)"MessageAttributeValue").add("StringValue", (Object)this.stringValue()).add("BinaryValue", (Object)this.binaryValue()).add("StringListValues", this.stringListValues()).add("BinaryListValues", this.binaryListValues()).add("DataType", (Object)this.dataType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.of(clazz.cast(this.stringValue()));
            }
            case "BinaryValue": {
                return Optional.of(clazz.cast(this.binaryValue()));
            }
            case "StringListValues": {
                return Optional.of(clazz.cast(this.stringListValues()));
            }
            case "BinaryListValues": {
                return Optional.of(clazz.cast(this.binaryListValues()));
            }
            case "DataType": {
                return Optional.of(clazz.cast(this.dataType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private ByteBuffer binaryValue;
        private List<String> stringListValues;
        private List<ByteBuffer> binaryListValues;
        private String dataType;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageAttributeValue model) {
            this.stringValue(model.stringValue);
            this.binaryValue(model.binaryValue);
            this.stringListValues(model.stringListValues);
            this.binaryListValues(model.binaryListValues);
            this.dataType(model.dataType);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue;
        }

        @Override
        public final Builder binaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
            return this;
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue = StandardMemberCopier.copy((ByteBuffer)binaryValue);
        }

        public final Collection<String> getStringListValues() {
            return this.stringListValues;
        }

        @Override
        public final Builder stringListValues(Collection<String> stringListValues) {
            this.stringListValues = StringListCopier.copy(stringListValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValues(String ... stringListValues) {
            this.stringListValues(Arrays.asList(stringListValues));
            return this;
        }

        public final void setStringListValues(Collection<String> stringListValues) {
            this.stringListValues = StringListCopier.copy(stringListValues);
        }

        public final Collection<ByteBuffer> getBinaryListValues() {
            return this.binaryListValues;
        }

        @Override
        public final Builder binaryListValues(Collection<ByteBuffer> binaryListValues) {
            this.binaryListValues = BinaryListCopier.copy(binaryListValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binaryListValues(ByteBuffer ... binaryListValues) {
            this.binaryListValues(Arrays.asList(binaryListValues));
            return this;
        }

        public final void setBinaryListValues(Collection<ByteBuffer> binaryListValues) {
            this.binaryListValues = BinaryListCopier.copy(binaryListValues);
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public MessageAttributeValue build() {
            return new MessageAttributeValue(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageAttributeValue> {
        public Builder stringValue(String var1);

        public Builder binaryValue(ByteBuffer var1);

        public Builder stringListValues(Collection<String> var1);

        public Builder stringListValues(String ... var1);

        public Builder binaryListValues(Collection<ByteBuffer> var1);

        public Builder binaryListValues(ByteBuffer ... var1);

        public Builder dataType(String var1);
    }
}

