/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sqs.model.QueueUrlListCopier;
import software.amazon.awssdk.services.sqs.model.SQSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeadLetterSourceQueuesResponse
extends SQSResponse
implements ToCopyableBuilder<Builder, ListDeadLetterSourceQueuesResponse> {
    private final List<String> queueUrls;

    private ListDeadLetterSourceQueuesResponse(BuilderImpl builder) {
        super(builder);
        this.queueUrls = builder.queueUrls;
    }

    public List<String> queueUrls() {
        return this.queueUrls;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrls());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeadLetterSourceQueuesResponse)) {
            return false;
        }
        ListDeadLetterSourceQueuesResponse other = (ListDeadLetterSourceQueuesResponse)((Object)obj);
        return Objects.equals(this.queueUrls(), other.queueUrls());
    }

    public String toString() {
        return ToString.builder((String)"ListDeadLetterSourceQueuesResponse").add("QueueUrls", this.queueUrls()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "queueUrls": {
                return Optional.of(clazz.cast(this.queueUrls()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSResponse.BuilderImpl
    implements Builder {
        private List<String> queueUrls;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeadLetterSourceQueuesResponse model) {
            super(model);
            this.queueUrls(model.queueUrls);
        }

        public final Collection<String> getQueueUrls() {
            return this.queueUrls;
        }

        @Override
        public final Builder queueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueUrls(String ... queueUrls) {
            this.queueUrls(Arrays.asList(queueUrls));
            return this;
        }

        public final void setQueueUrls(Collection<String> queueUrls) {
            this.queueUrls = QueueUrlListCopier.copy(queueUrls);
        }

        @Override
        public ListDeadLetterSourceQueuesResponse build() {
            return new ListDeadLetterSourceQueuesResponse(this);
        }
    }

    public static interface Builder
    extends SQSResponse.Builder,
    CopyableBuilder<Builder, ListDeadLetterSourceQueuesResponse> {
        public Builder queueUrls(Collection<String> var1);

        public Builder queueUrls(String ... var1);
    }
}

