/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.sqs.model.SQSRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeMessageVisibilityRequest
extends SQSRequest
implements ToCopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
    private final String queueUrl;
    private final String receiptHandle;
    private final Integer visibilityTimeout;

    private ChangeMessageVisibilityRequest(BuilderImpl builder) {
        super(builder);
        this.queueUrl = builder.queueUrl;
        this.receiptHandle = builder.receiptHandle;
        this.visibilityTimeout = builder.visibilityTimeout;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public String receiptHandle() {
        return this.receiptHandle;
    }

    public Integer visibilityTimeout() {
        return this.visibilityTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.receiptHandle());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityTimeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityRequest)) {
            return false;
        }
        ChangeMessageVisibilityRequest other = (ChangeMessageVisibilityRequest)((Object)obj);
        return Objects.equals(this.queueUrl(), other.queueUrl()) && Objects.equals(this.receiptHandle(), other.receiptHandle()) && Objects.equals(this.visibilityTimeout(), other.visibilityTimeout());
    }

    public String toString() {
        return ToString.builder((String)"ChangeMessageVisibilityRequest").add("QueueUrl", (Object)this.queueUrl()).add("ReceiptHandle", (Object)this.receiptHandle()).add("VisibilityTimeout", (Object)this.visibilityTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueueUrl": {
                return Optional.of(clazz.cast(this.queueUrl()));
            }
            case "ReceiptHandle": {
                return Optional.of(clazz.cast(this.receiptHandle()));
            }
            case "VisibilityTimeout": {
                return Optional.of(clazz.cast(this.visibilityTimeout()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SQSRequest.BuilderImpl
    implements Builder {
        private String queueUrl;
        private String receiptHandle;
        private Integer visibilityTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityRequest model) {
            super(model);
            this.queueUrl(model.queueUrl);
            this.receiptHandle(model.receiptHandle);
            this.visibilityTimeout(model.visibilityTimeout);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final String getReceiptHandle() {
            return this.receiptHandle;
        }

        @Override
        public final Builder receiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
            return this;
        }

        public final void setReceiptHandle(String receiptHandle) {
            this.receiptHandle = receiptHandle;
        }

        public final Integer getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final Builder visibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public final void setVisibilityTimeout(Integer visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ChangeMessageVisibilityRequest build() {
            return new ChangeMessageVisibilityRequest(this);
        }
    }

    public static interface Builder
    extends SQSRequest.Builder,
    CopyableBuilder<Builder, ChangeMessageVisibilityRequest> {
        public Builder queueUrl(String var1);

        public Builder receiptHandle(String var1);

        public Builder visibilityTimeout(Integer var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

