/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.transform;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateQueueRequestMarshaller
implements Marshaller<Request<CreateQueueRequest>, CreateQueueRequest> {
    public Request<CreateQueueRequest> marshall(CreateQueueRequest createQueueRequest) {
        if (createQueueRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createQueueRequest, "SQSClient");
        request.addParameter("Action", "CreateQueue");
        request.addParameter("Version", "2012-11-05");
        request.setHttpMethod(HttpMethodName.POST);
        if (createQueueRequest.queueName() != null) {
            request.addParameter("QueueName", StringUtils.fromString((String)createQueueRequest.queueName()));
        }
        Map<String, String> attributes = createQueueRequest.attributes();
        int attributesListIndex = 1;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (entry.getKey() != null) {
                request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString((String)entry.getKey()));
            }
            if (entry.getValue() != null) {
                request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString((String)entry.getValue()));
            }
            ++attributesListIndex;
        }
        return request;
    }
}

