/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.services.sqs.model.QueueAttributeMapCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetQueueAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetQueueAttributesRequest> {
    private final String queueUrl;
    private final Map<String, String> attributes;

    private SetQueueAttributesRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.attributes = builder.attributes;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetQueueAttributesRequest)) {
            return false;
        }
        SetQueueAttributesRequest other = (SetQueueAttributesRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        return other.attributes() == null || other.attributes().equals(this.attributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private Map<String, String> attributes = new SdkInternalMap();

        private BuilderImpl() {
        }

        private BuilderImpl(SetQueueAttributesRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setAttributes(model.attributes);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = QueueAttributeMapCopier.copy(attributes);
        }

        public SetQueueAttributesRequest build() {
            return new SetQueueAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetQueueAttributesRequest> {
        public Builder queueUrl(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

