/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntryListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChangeMessageVisibilityBatchRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ChangeMessageVisibilityBatchRequest> {
    private final String queueUrl;
    private final List<ChangeMessageVisibilityBatchRequestEntry> entries;

    private ChangeMessageVisibilityBatchRequest(BuilderImpl builder) {
        this.queueUrl = builder.queueUrl;
        this.entries = builder.entries;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    public List<ChangeMessageVisibilityBatchRequestEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queueUrl() == null ? 0 : this.queueUrl().hashCode());
        hashCode = 31 * hashCode + (this.entries() == null ? 0 : this.entries().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequest)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequest other = (ChangeMessageVisibilityBatchRequest)((Object)obj);
        if (other.queueUrl() == null ^ this.queueUrl() == null) {
            return false;
        }
        if (other.queueUrl() != null && !other.queueUrl().equals(this.queueUrl())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        return other.entries() == null || other.entries().equals(this.entries());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queueUrl() != null) {
            sb.append("QueueUrl: ").append(this.queueUrl()).append(",");
        }
        if (this.entries() != null) {
            sb.append("Entries: ").append(this.entries()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String queueUrl;
        private List<ChangeMessageVisibilityBatchRequestEntry> entries = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeMessageVisibilityBatchRequest model) {
            this.setQueueUrl(model.queueUrl);
            this.setEntries(model.entries);
        }

        public final String getQueueUrl() {
            return this.queueUrl;
        }

        @Override
        public final Builder queueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public final void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public final Collection<ChangeMessageVisibilityBatchRequestEntry> getEntries() {
            return this.entries;
        }

        @Override
        public final Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(ChangeMessageVisibilityBatchRequestEntry ... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList(entries.length);
            }
            for (ChangeMessageVisibilityBatchRequestEntry e : entries) {
                this.entries.add(e);
            }
            return this;
        }

        public final void setEntries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
            this.entries = ChangeMessageVisibilityBatchRequestEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(ChangeMessageVisibilityBatchRequestEntry ... entries) {
            if (this.entries == null) {
                this.entries = new SdkInternalList(entries.length);
            }
            for (ChangeMessageVisibilityBatchRequestEntry e : entries) {
                this.entries.add(e);
            }
        }

        public ChangeMessageVisibilityBatchRequest build() {
            return new ChangeMessageVisibilityBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChangeMessageVisibilityBatchRequest> {
        public Builder queueUrl(String var1);

        public Builder entries(Collection<ChangeMessageVisibilityBatchRequestEntry> var1);

        public Builder entries(ChangeMessageVisibilityBatchRequestEntry ... var1);
    }
}

