/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.buffered;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferCallback;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferConfig;
import software.amazon.awssdk.services.sqs.buffered.QueueBufferFuture;
import software.amazon.awssdk.services.sqs.buffered.ResultConverter;
import software.amazon.awssdk.services.sqs.buffered.SqsBufferedAsyncClient;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;

public class ReceiveQueueBuffer {
    private static Log log = LogFactory.getLog(ReceiveQueueBuffer.class);
    volatile boolean shutDown = false;
    private final QueueBufferConfig config;
    private final String qUrl;
    private final Executor executor;
    private final SQSAsyncClient sqsClient;
    private final Object taskSpawnSyncPoint = new Object();
    private final LinkedList<ReceiveMessageFuture> futures = new LinkedList();
    private long bufferCounter = 0L;
    private volatile long visibilityTimeoutNanos = -1L;
    private volatile int inflightReceiveMessageBatches;
    private LinkedList<ReceiveMessageBatchTask> finishedTasks = new LinkedList();

    ReceiveQueueBuffer(SQSAsyncClient paramSqs, Executor paramExecutor, QueueBufferConfig paramConfig, String url) {
        this.config = paramConfig;
        this.executor = paramExecutor;
        this.sqsClient = paramSqs;
        this.qUrl = url;
    }

    public void shutdown() {
        this.shutDown = true;
        try {
            while (this.inflightReceiveMessageBatches > 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResponse> receiveMessageAsync(ReceiveMessageRequest rq, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResponse> callback) {
        if (this.shutDown) {
            throw new AmazonClientException("The client has been shut down.");
        }
        int numMessages = 10;
        if (rq.maxNumberOfMessages() != null) {
            numMessages = rq.maxNumberOfMessages();
        }
        ReceiveMessageFuture toReturn = this.issueFuture(numMessages, callback);
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveMessageFuture issueFuture(int size, QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResponse> callback) {
        LinkedList<ReceiveMessageFuture> linkedList = this.futures;
        synchronized (linkedList) {
            ReceiveMessageFuture theFuture = new ReceiveMessageFuture(callback, size);
            this.futures.addLast(theFuture);
            return theFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void satisfyFuturesFromBuffer() {
        LinkedList<ReceiveMessageFuture> linkedList = this.futures;
        synchronized (linkedList) {
            LinkedList<ReceiveMessageBatchTask> linkedList2 = this.finishedTasks;
            synchronized (linkedList2) {
                while (!this.futures.isEmpty() && !this.finishedTasks.isEmpty()) {
                    this.pruneExpiredTasks();
                    if (this.finishedTasks.isEmpty()) continue;
                    this.fufillFuture(this.futures.poll());
                }
            }
        }
    }

    private void fufillFuture(ReceiveMessageFuture future) {
        ReceiveMessageBatchTask task = this.finishedTasks.getFirst();
        ReceiveMessageResponse.Builder resultBuilder = ReceiveMessageResponse.builder();
        LinkedList<Message> messages = new LinkedList<Message>();
        Exception exception = task.getException();
        boolean batchDone = false;
        for (int numRetrieved = 0; numRetrieved < future.getRequestedSize(); ++numRetrieved) {
            Message msg = task.removeMessage();
            if (msg != null) {
                messages.add(msg);
                continue;
            }
            batchDone = true;
            break;
        }
        boolean bl = batchDone = batchDone || task.isEmpty() || exception != null;
        if (batchDone) {
            this.finishedTasks.removeFirst();
        }
        resultBuilder.messages(messages);
        if (exception != null) {
            future.setFailure(exception);
        } else {
            future.setSuccess(resultBuilder.build());
        }
    }

    private void pruneExpiredTasks() {
        int numberExpiredTasksPruned = this.pruneHeadTasks(new Predicate<ReceiveMessageBatchTask>(){

            @Override
            public boolean test(ReceiveMessageBatchTask t) {
                return t.isExpired() && t.getException() == null;
            }
        });
        if (numberExpiredTasksPruned > 0) {
            this.pruneHeadTasks(new Predicate<ReceiveMessageBatchTask>(){

                @Override
                public boolean test(ReceiveMessageBatchTask t) {
                    return t.isEmpty() && t.getException() == null;
                }
            });
        }
    }

    private int pruneHeadTasks(Predicate<ReceiveMessageBatchTask> pruneCondition) {
        int numberPruned = 0;
        while (!this.finishedTasks.isEmpty() && pruneCondition.test(this.finishedTasks.getFirst())) {
            this.finishedTasks.removeFirst();
            ++numberPruned;
        }
        return numberPruned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spawnMoreReceiveTasks() {
        if (this.shutDown) {
            return;
        }
        int desiredBatches = this.config.getMaxDoneReceiveBatches();
        desiredBatches = desiredBatches < 1 ? 1 : desiredBatches;
        Object object = this.finishedTasks;
        synchronized (object) {
            if (this.finishedTasks.size() >= desiredBatches) {
                return;
            }
            if (this.finishedTasks.size() > 0 && this.finishedTasks.size() + this.inflightReceiveMessageBatches >= desiredBatches) {
                return;
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            int max;
            int toSpawn;
            if (this.visibilityTimeoutNanos == -1L) {
                GetQueueAttributesRequest request = (GetQueueAttributesRequest)((Object)GetQueueAttributesRequest.builder().queueUrl(this.qUrl).attributeNames("VisibilityTimeout").build());
                ResultConverter.appendUserAgent(request, SqsBufferedAsyncClient.USER_AGENT);
                long visibilityTimeoutSeconds = Long.parseLong(this.sqsClient.getQueueAttributes(request).join().attributes().get("VisibilityTimeout"));
                this.visibilityTimeoutNanos = TimeUnit.NANOSECONDS.convert(visibilityTimeoutSeconds, TimeUnit.SECONDS);
            }
            if ((toSpawn = (max = (max = this.config.getMaxInflightReceiveBatches()) > 0 ? max : 1) - this.inflightReceiveMessageBatches) > 0) {
                ReceiveMessageBatchTask task = new ReceiveMessageBatchTask(this);
                ++this.inflightReceiveMessageBatches;
                ++this.bufferCounter;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Spawned receive batch #" + this.bufferCounter + " (" + this.inflightReceiveMessageBatches + " of " + max + " inflight) for queue " + this.qUrl));
                }
                this.executor.execute(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportBatchFinished(ReceiveMessageBatchTask batch) {
        Object object = this.finishedTasks;
        synchronized (object) {
            this.finishedTasks.addLast(batch);
            if (log.isTraceEnabled()) {
                log.info((Object)("Queue " + this.qUrl + " now has " + this.finishedTasks.size() + " receive results cached "));
            }
        }
        object = this.taskSpawnSyncPoint;
        synchronized (object) {
            --this.inflightReceiveMessageBatches;
        }
        this.satisfyFuturesFromBuffer();
        this.spawnMoreReceiveTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        boolean done = false;
        while (!done) {
            ReceiveMessageBatchTask currentBatch = null;
            LinkedList<ReceiveMessageBatchTask> linkedList = this.finishedTasks;
            synchronized (linkedList) {
                currentBatch = this.finishedTasks.poll();
            }
            if (currentBatch != null) {
                currentBatch.clear();
                continue;
            }
            done = true;
        }
    }

    private class ReceiveMessageBatchTask
    implements Runnable {
        private Exception exception = null;
        private List<Message> messages;
        private long visibilityDeadlineNano;
        private boolean open = false;
        private ReceiveQueueBuffer parentBuffer;

        ReceiveMessageBatchTask(ReceiveQueueBuffer paramParentBuffer) {
            this.parentBuffer = paramParentBuffer;
            this.messages = Collections.emptyList();
        }

        synchronized boolean isEmpty() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.messages.isEmpty();
        }

        synchronized Exception getException() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            return this.exception;
        }

        synchronized Message removeMessage() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (this.isExpired()) {
                this.messages.clear();
                return null;
            }
            if (this.messages.isEmpty()) {
                return null;
            }
            return this.messages.remove(this.messages.size() - 1);
        }

        boolean isExpired() {
            return System.nanoTime() > this.visibilityDeadlineNano;
        }

        synchronized void clear() {
            if (!this.open) {
                throw new IllegalStateException("batch is not open");
            }
            if (!this.isExpired()) {
                ChangeMessageVisibilityBatchRequest.Builder batchRequestBuilder = ChangeMessageVisibilityBatchRequest.builder().queueUrl(ReceiveQueueBuffer.this.qUrl);
                ArrayList<ChangeMessageVisibilityBatchRequestEntry> entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(this.messages.size());
                int i = 0;
                for (Message m : this.messages) {
                    entries.add((ChangeMessageVisibilityBatchRequestEntry)ChangeMessageVisibilityBatchRequestEntry.builder().id(Integer.toString(i)).receiptHandle(m.receiptHandle()).visibilityTimeout(0).build());
                    ++i;
                }
                batchRequestBuilder.entries(entries);
                ChangeMessageVisibilityBatchRequest batchRequest = (ChangeMessageVisibilityBatchRequest)((Object)batchRequestBuilder.build());
                ResultConverter.appendUserAgent(batchRequest, SqsBufferedAsyncClient.USER_AGENT);
                try {
                    ReceiveQueueBuffer.this.sqsClient.changeMessageVisibilityBatch(batchRequest);
                }
                catch (AmazonClientException e) {
                    log.warn((Object)("ReceiveMessageBatchTask: changeMessageVisibility failed " + (Object)((Object)e)));
                }
            }
            this.messages.clear();
        }

        @Override
        public void run() {
            try {
                this.visibilityDeadlineNano = System.nanoTime() + ReceiveQueueBuffer.this.visibilityTimeoutNanos;
                ReceiveMessageRequest.Builder requestBuilder = ReceiveMessageRequest.builder().queueUrl(ReceiveQueueBuffer.this.qUrl).maxNumberOfMessages(ReceiveQueueBuffer.this.config.getMaxBatchSize());
                if (ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds() > 0) {
                    requestBuilder.visibilityTimeout(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds());
                    this.visibilityDeadlineNano = System.nanoTime() + TimeUnit.NANOSECONDS.convert(ReceiveQueueBuffer.this.config.getVisibilityTimeoutSeconds(), TimeUnit.SECONDS);
                }
                if (ReceiveQueueBuffer.this.config.isLongPoll()) {
                    requestBuilder.waitTimeSeconds(ReceiveQueueBuffer.this.config.getLongPollWaitTimeoutSeconds());
                }
                ReceiveMessageRequest request = (ReceiveMessageRequest)((Object)requestBuilder.build());
                ResultConverter.appendUserAgent(request, SqsBufferedAsyncClient.USER_AGENT);
                this.messages = ReceiveQueueBuffer.this.sqsClient.receiveMessage(request).join().messages();
            }
            catch (AmazonClientException e) {
                this.exception = e;
            }
            finally {
                this.open = true;
                this.parentBuffer.reportBatchFinished(this);
            }
        }
    }

    private class ReceiveMessageFuture
    extends QueueBufferFuture<ReceiveMessageRequest, ReceiveMessageResponse> {
        private int requestedSize;

        ReceiveMessageFuture(QueueBufferCallback<ReceiveMessageRequest, ReceiveMessageResponse> cb, int paramSize) {
            super(cb);
            this.requestedSize = paramSize;
        }

        public int getRequestedSize() {
            return this.requestedSize;
        }
    }

    private static interface Predicate<T> {
        public boolean test(T var1);
    }
}

