/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.w3c.dom.Node;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.client.AsyncClientHandler;
import software.amazon.awssdk.client.AwsAsyncClientParams;
import software.amazon.awssdk.client.AwsSyncClientParams;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.client.ClientHandlerParams;
import software.amazon.awssdk.client.SdkAsyncClientHandler;
import software.amazon.awssdk.http.DefaultErrorResponseHandler;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.StaxResponseHandler;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.runtime.transform.StandardErrorUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.sqs.SQSAsyncClient;
import software.amazon.awssdk.services.sqs.model.AddPermissionRequest;
import software.amazon.awssdk.services.sqs.model.AddPermissionResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityBatchResponse;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityRequest;
import software.amazon.awssdk.services.sqs.model.ChangeMessageVisibilityResponse;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.CreateQueueResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;
import software.amazon.awssdk.services.sqs.model.DeleteMessageResponse;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListDeadLetterSourceQueuesResponse;
import software.amazon.awssdk.services.sqs.model.ListQueuesRequest;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.PurgeQueueRequest;
import software.amazon.awssdk.services.sqs.model.PurgeQueueResponse;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageRequest;
import software.amazon.awssdk.services.sqs.model.ReceiveMessageResponse;
import software.amazon.awssdk.services.sqs.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sqs.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sqs.model.SQSException;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.transform.AddPermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.AddPermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.BatchEntryIdsNotDistinctExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.BatchRequestTooLongExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ChangeMessageVisibilityResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.CreateQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.DeleteQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.EmptyBatchRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.GetQueueUrlResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidAttributeNameExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidBatchEntryIdExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidIdFormatExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.InvalidMessageContentsExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListDeadLetterSourceQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ListQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.MessageNotInflightExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.OverLimitExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueInProgressExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.PurgeQueueResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueDeletedRecentlyExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueDoesNotExistExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.QueueNameExistsExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiptHandleIsInvalidExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.ReceiveMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.RemovePermissionResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageBatchResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SendMessageResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesRequestMarshaller;
import software.amazon.awssdk.services.sqs.transform.SetQueueAttributesResponseUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.TooManyEntriesInBatchRequestExceptionUnmarshaller;
import software.amazon.awssdk.services.sqs.transform.UnsupportedOperationExceptionUnmarshaller;

@SdkInternalApi
final class DefaultSQSAsyncClient
implements SQSAsyncClient {
    private final AsyncClientHandler clientHandler;
    private final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;

    protected DefaultSQSAsyncClient(AwsAsyncClientParams clientParams) {
        this.clientHandler = new SdkAsyncClientHandler(new ClientHandlerParams().withAsyncClientParams(clientParams).withClientParams((AwsSyncClientParams)clientParams).withCalculateCrc32FromCompressedDataEnabled(false));
        this.exceptionUnmarshallers = this.init();
    }

    @Override
    public CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new AddPermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new AddPermissionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)addPermissionRequest));
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityResponse> changeMessageVisibility(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ChangeMessageVisibilityRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)changeMessageVisibilityRequest));
    }

    @Override
    public CompletableFuture<ChangeMessageVisibilityBatchResponse> changeMessageVisibilityBatch(ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ChangeMessageVisibilityBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ChangeMessageVisibilityBatchRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)changeMessageVisibilityBatchRequest));
    }

    @Override
    public CompletableFuture<CreateQueueResponse> createQueue(CreateQueueRequest createQueueRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new CreateQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new CreateQueueRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)createQueueRequest));
    }

    @Override
    public CompletableFuture<DeleteMessageResponse> deleteMessage(DeleteMessageRequest deleteMessageRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteMessageRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteMessageRequest));
    }

    @Override
    public CompletableFuture<DeleteMessageBatchResponse> deleteMessageBatch(DeleteMessageBatchRequest deleteMessageBatchRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteMessageBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteMessageBatchRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteMessageBatchRequest));
    }

    @Override
    public CompletableFuture<DeleteQueueResponse> deleteQueue(DeleteQueueRequest deleteQueueRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new DeleteQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new DeleteQueueRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)deleteQueueRequest));
    }

    @Override
    public CompletableFuture<GetQueueAttributesResponse> getQueueAttributes(GetQueueAttributesRequest getQueueAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetQueueAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getQueueAttributesRequest));
    }

    @Override
    public CompletableFuture<GetQueueUrlResponse> getQueueUrl(GetQueueUrlRequest getQueueUrlRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new GetQueueUrlResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new GetQueueUrlRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)getQueueUrlRequest));
    }

    @Override
    public CompletableFuture<ListDeadLetterSourceQueuesResponse> listDeadLetterSourceQueues(ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListDeadLetterSourceQueuesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListDeadLetterSourceQueuesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listDeadLetterSourceQueuesRequest));
    }

    @Override
    public CompletableFuture<ListQueuesResponse> listQueues(ListQueuesRequest listQueuesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ListQueuesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ListQueuesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)listQueuesRequest));
    }

    @Override
    public CompletableFuture<PurgeQueueResponse> purgeQueue(PurgeQueueRequest purgeQueueRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new PurgeQueueResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new PurgeQueueRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)purgeQueueRequest));
    }

    @Override
    public CompletableFuture<ReceiveMessageResponse> receiveMessage(ReceiveMessageRequest receiveMessageRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new ReceiveMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new ReceiveMessageRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)receiveMessageRequest));
    }

    @Override
    public CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new RemovePermissionResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new RemovePermissionRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)removePermissionRequest));
    }

    @Override
    public CompletableFuture<SendMessageResponse> sendMessage(SendMessageRequest sendMessageRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SendMessageRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)sendMessageRequest));
    }

    @Override
    public CompletableFuture<SendMessageBatchResponse> sendMessageBatch(SendMessageBatchRequest sendMessageBatchRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SendMessageBatchResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SendMessageBatchRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)sendMessageBatchRequest));
    }

    @Override
    public CompletableFuture<SetQueueAttributesResponse> setQueueAttributes(SetQueueAttributesRequest setQueueAttributesRequest) {
        StaxResponseHandler responseHandler = new StaxResponseHandler((Unmarshaller)new SetQueueAttributesResponseUnmarshaller());
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.clientHandler.execute(new ClientExecutionParams().withMarshaller((Marshaller)new SetQueueAttributesRequestMarshaller()).withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler((HttpResponseHandler)errorResponseHandler).withInput((Object)setQueueAttributesRequest));
    }

    @Override
    public void close() throws Exception {
        this.clientHandler.close();
    }

    private List<Unmarshaller<AmazonServiceException, Node>> init() {
        ArrayList<Unmarshaller<AmazonServiceException, Node>> unmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PurgeQueueInProgressExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidAttributeNameExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BatchEntryIdsNotDistinctExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TooManyEntriesInBatchRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new BatchRequestTooLongExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new UnsupportedOperationExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidIdFormatExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new OverLimitExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueDoesNotExistExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueNameExistsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new MessageNotInflightExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ReceiptHandleIsInvalidExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidMessageContentsExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new QueueDeletedRecentlyExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new EmptyBatchRequestExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidBatchEntryIdExceptionUnmarshaller());
        unmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller(SQSException.class));
        return unmarshallers;
    }
}

