/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingClient;
import software.amazon.awssdk.services.socialmessaging.SocialMessagingServiceClientConfiguration;
import software.amazon.awssdk.services.socialmessaging.internal.SocialMessagingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedByMetaException;
import software.amazon.awssdk.services.socialmessaging.model.AccessDeniedException;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.AssociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.DeleteWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.DependencyException;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.DisassociateWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountPhoneNumberResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetLinkedWhatsAppBusinessAccountResponse;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.GetWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.InternalServiceException;
import software.amazon.awssdk.services.socialmessaging.model.InvalidParametersException;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListLinkedWhatsAppBusinessAccountsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaRequest;
import software.amazon.awssdk.services.socialmessaging.model.PostWhatsAppMessageMediaResponse;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsRequest;
import software.amazon.awssdk.services.socialmessaging.model.PutWhatsAppBusinessAccountEventDestinationsResponse;
import software.amazon.awssdk.services.socialmessaging.model.ResourceNotFoundException;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageRequest;
import software.amazon.awssdk.services.socialmessaging.model.SendWhatsAppMessageResponse;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingException;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.TagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ThrottledRequestException;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceRequest;
import software.amazon.awssdk.services.socialmessaging.model.UntagResourceResponse;
import software.amazon.awssdk.services.socialmessaging.model.ValidationException;
import software.amazon.awssdk.services.socialmessaging.transform.AssociateWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.DeleteWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.DisassociateWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetLinkedWhatsAppBusinessAccountPhoneNumberRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetLinkedWhatsAppBusinessAccountRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.GetWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListLinkedWhatsAppBusinessAccountsRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.PostWhatsAppMessageMediaRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.PutWhatsAppBusinessAccountEventDestinationsRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.SendWhatsAppMessageRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.socialmessaging.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSocialMessagingClient
implements SocialMessagingClient {
    private static final Logger log = Logger.loggerFor(DefaultSocialMessagingClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSocialMessagingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateWhatsAppBusinessAccountResponse associateWhatsAppBusinessAccount(AssociateWhatsAppBusinessAccountRequest associateWhatsAppBusinessAccountRequest) throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateWhatsAppBusinessAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, associateWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateWhatsAppBusinessAccount");
            AssociateWhatsAppBusinessAccountResponse associateWhatsAppBusinessAccountResponse = (AssociateWhatsAppBusinessAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateWhatsAppBusinessAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateWhatsAppBusinessAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$associateWhatsAppBusinessAccount$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWhatsAppMessageMediaResponse deleteWhatsAppMessageMedia(DeleteWhatsAppMessageMediaRequest deleteWhatsAppMessageMediaRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWhatsAppMessageMediaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, deleteWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWhatsAppMessageMedia");
            DeleteWhatsAppMessageMediaResponse deleteWhatsAppMessageMediaResponse = (DeleteWhatsAppMessageMediaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteWhatsAppMessageMediaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWhatsAppMessageMediaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$deleteWhatsAppMessageMedia$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateWhatsAppBusinessAccountResponse disassociateWhatsAppBusinessAccount(DisassociateWhatsAppBusinessAccountRequest disassociateWhatsAppBusinessAccountRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateWhatsAppBusinessAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, disassociateWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateWhatsAppBusinessAccount");
            DisassociateWhatsAppBusinessAccountResponse disassociateWhatsAppBusinessAccountResponse = (DisassociateWhatsAppBusinessAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateWhatsAppBusinessAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateWhatsAppBusinessAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$disassociateWhatsAppBusinessAccount$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLinkedWhatsAppBusinessAccountResponse getLinkedWhatsAppBusinessAccount(GetLinkedWhatsAppBusinessAccountRequest getLinkedWhatsAppBusinessAccountRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkedWhatsAppBusinessAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLinkedWhatsAppBusinessAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, getLinkedWhatsAppBusinessAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkedWhatsAppBusinessAccount");
            GetLinkedWhatsAppBusinessAccountResponse getLinkedWhatsAppBusinessAccountResponse = (GetLinkedWhatsAppBusinessAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkedWhatsAppBusinessAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLinkedWhatsAppBusinessAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLinkedWhatsAppBusinessAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLinkedWhatsAppBusinessAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$getLinkedWhatsAppBusinessAccount$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLinkedWhatsAppBusinessAccountPhoneNumberResponse getLinkedWhatsAppBusinessAccountPhoneNumber(GetLinkedWhatsAppBusinessAccountPhoneNumberRequest getLinkedWhatsAppBusinessAccountPhoneNumberRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkedWhatsAppBusinessAccountPhoneNumberResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLinkedWhatsAppBusinessAccountPhoneNumberRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, getLinkedWhatsAppBusinessAccountPhoneNumberRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkedWhatsAppBusinessAccountPhoneNumber");
            GetLinkedWhatsAppBusinessAccountPhoneNumberResponse getLinkedWhatsAppBusinessAccountPhoneNumberResponse = (GetLinkedWhatsAppBusinessAccountPhoneNumberResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkedWhatsAppBusinessAccountPhoneNumber").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLinkedWhatsAppBusinessAccountPhoneNumberRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLinkedWhatsAppBusinessAccountPhoneNumberRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLinkedWhatsAppBusinessAccountPhoneNumberResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWhatsAppMessageMediaResponse getWhatsAppMessageMedia(GetWhatsAppMessageMediaRequest getWhatsAppMessageMediaRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWhatsAppMessageMediaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, getWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWhatsAppMessageMedia");
            GetWhatsAppMessageMediaResponse getWhatsAppMessageMediaResponse = (GetWhatsAppMessageMediaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getWhatsAppMessageMediaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWhatsAppMessageMediaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$getWhatsAppMessageMedia$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLinkedWhatsAppBusinessAccountsResponse listLinkedWhatsAppBusinessAccounts(ListLinkedWhatsAppBusinessAccountsRequest listLinkedWhatsAppBusinessAccountsRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLinkedWhatsAppBusinessAccountsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLinkedWhatsAppBusinessAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, listLinkedWhatsAppBusinessAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLinkedWhatsAppBusinessAccounts");
            ListLinkedWhatsAppBusinessAccountsResponse listLinkedWhatsAppBusinessAccountsResponse = (ListLinkedWhatsAppBusinessAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLinkedWhatsAppBusinessAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listLinkedWhatsAppBusinessAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListLinkedWhatsAppBusinessAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listLinkedWhatsAppBusinessAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$listLinkedWhatsAppBusinessAccounts$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$listTagsForResource$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PostWhatsAppMessageMediaResponse postWhatsAppMessageMedia(PostWhatsAppMessageMediaRequest postWhatsAppMessageMediaRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, AccessDeniedByMetaException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PostWhatsAppMessageMediaResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)postWhatsAppMessageMediaRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, postWhatsAppMessageMediaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PostWhatsAppMessageMedia");
            PostWhatsAppMessageMediaResponse postWhatsAppMessageMediaResponse = (PostWhatsAppMessageMediaResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PostWhatsAppMessageMedia").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)postWhatsAppMessageMediaRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PostWhatsAppMessageMediaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return postWhatsAppMessageMediaResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$postWhatsAppMessageMedia$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutWhatsAppBusinessAccountEventDestinationsResponse putWhatsAppBusinessAccountEventDestinations(PutWhatsAppBusinessAccountEventDestinationsRequest putWhatsAppBusinessAccountEventDestinationsRequest) throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutWhatsAppBusinessAccountEventDestinationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putWhatsAppBusinessAccountEventDestinationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, putWhatsAppBusinessAccountEventDestinationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutWhatsAppBusinessAccountEventDestinations");
            PutWhatsAppBusinessAccountEventDestinationsResponse putWhatsAppBusinessAccountEventDestinationsResponse = (PutWhatsAppBusinessAccountEventDestinationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutWhatsAppBusinessAccountEventDestinations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putWhatsAppBusinessAccountEventDestinationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutWhatsAppBusinessAccountEventDestinationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putWhatsAppBusinessAccountEventDestinationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$putWhatsAppBusinessAccountEventDestinations$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendWhatsAppMessageResponse sendWhatsAppMessage(SendWhatsAppMessageRequest sendWhatsAppMessageRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, InvalidParametersException, ThrottledRequestException, InternalServiceException, DependencyException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendWhatsAppMessageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendWhatsAppMessageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, sendWhatsAppMessageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendWhatsAppMessage");
            SendWhatsAppMessageResponse sendWhatsAppMessageResponse = (SendWhatsAppMessageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendWhatsAppMessage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendWhatsAppMessageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendWhatsAppMessageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendWhatsAppMessageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$sendWhatsAppMessage$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$tagResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AccessDeniedException, InvalidParametersException, ThrottledRequestException, InternalServiceException, AwsServiceException, SdkClientException, SocialMessagingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ThrottledRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottledRequestException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottledRequestException::builder).build());
                }
                case "AccessDeniedByMetaException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedByMetaException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedByMetaException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidParametersException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParametersException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParametersException::builder).build());
                }
                case "DependencyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DependencyException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(DependencyException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServiceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServiceException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServiceException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSocialMessagingClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"SocialMessaging");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultSocialMessagingClient.lambda$untagResource$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "social-messaging";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SocialMessagingServiceClientConfigurationBuilder serviceConfigBuilder = new SocialMessagingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(SocialMessagingException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final SocialMessagingServiceClientConfiguration serviceClientConfiguration() {
        return new SocialMessagingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$untagResource$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendWhatsAppMessage$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putWhatsAppBusinessAccountEventDestinations$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$postWhatsAppMessageMedia$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLinkedWhatsAppBusinessAccounts$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWhatsAppMessageMedia$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccountPhoneNumber$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkedWhatsAppBusinessAccount$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateWhatsAppBusinessAccount$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWhatsAppMessageMedia$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateWhatsAppBusinessAccount$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

