/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.socialmessaging.model.RegistrationStatus;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetail;
import software.amazon.awssdk.services.socialmessaging.model.WhatsAppPhoneNumberDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkedWhatsAppBusinessAccountIdMetaData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkedWhatsAppBusinessAccountIdMetaData> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountName").getter(LinkedWhatsAppBusinessAccountIdMetaData.getter(LinkedWhatsAppBusinessAccountIdMetaData::accountName)).setter(LinkedWhatsAppBusinessAccountIdMetaData.setter(Builder::accountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountName").build()}).build();
    private static final SdkField<String> REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registrationStatus").getter(LinkedWhatsAppBusinessAccountIdMetaData.getter(LinkedWhatsAppBusinessAccountIdMetaData::registrationStatusAsString)).setter(LinkedWhatsAppBusinessAccountIdMetaData.setter(Builder::registrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registrationStatus").build()}).build();
    private static final SdkField<List<WhatsAppPhoneNumberDetail>> UNREGISTERED_WHATS_APP_PHONE_NUMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("unregisteredWhatsAppPhoneNumbers").getter(LinkedWhatsAppBusinessAccountIdMetaData.getter(LinkedWhatsAppBusinessAccountIdMetaData::unregisteredWhatsAppPhoneNumbers)).setter(LinkedWhatsAppBusinessAccountIdMetaData.setter(Builder::unregisteredWhatsAppPhoneNumbers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredWhatsAppPhoneNumbers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WhatsAppPhoneNumberDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD, REGISTRATION_STATUS_FIELD, UNREGISTERED_WHATS_APP_PHONE_NUMBERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountName;
    private final String registrationStatus;
    private final List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers;

    private LinkedWhatsAppBusinessAccountIdMetaData(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.registrationStatus = builder.registrationStatus;
        this.unregisteredWhatsAppPhoneNumbers = builder.unregisteredWhatsAppPhoneNumbers;
    }

    public final String accountName() {
        return this.accountName;
    }

    public final RegistrationStatus registrationStatus() {
        return RegistrationStatus.fromValue(this.registrationStatus);
    }

    public final String registrationStatusAsString() {
        return this.registrationStatus;
    }

    public final boolean hasUnregisteredWhatsAppPhoneNumbers() {
        return this.unregisteredWhatsAppPhoneNumbers != null && !(this.unregisteredWhatsAppPhoneNumbers instanceof SdkAutoConstructList);
    }

    public final List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers() {
        return this.unregisteredWhatsAppPhoneNumbers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnregisteredWhatsAppPhoneNumbers() ? this.unregisteredWhatsAppPhoneNumbers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkedWhatsAppBusinessAccountIdMetaData)) {
            return false;
        }
        LinkedWhatsAppBusinessAccountIdMetaData other = (LinkedWhatsAppBusinessAccountIdMetaData)obj;
        return Objects.equals(this.accountName(), other.accountName()) && Objects.equals(this.registrationStatusAsString(), other.registrationStatusAsString()) && this.hasUnregisteredWhatsAppPhoneNumbers() == other.hasUnregisteredWhatsAppPhoneNumbers() && Objects.equals(this.unregisteredWhatsAppPhoneNumbers(), other.unregisteredWhatsAppPhoneNumbers());
    }

    public final String toString() {
        return ToString.builder((String)"LinkedWhatsAppBusinessAccountIdMetaData").add("AccountName", (Object)this.accountName()).add("RegistrationStatus", (Object)this.registrationStatusAsString()).add("UnregisteredWhatsAppPhoneNumbers", this.hasUnregisteredWhatsAppPhoneNumbers() ? this.unregisteredWhatsAppPhoneNumbers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountName": {
                return Optional.ofNullable(clazz.cast(this.accountName()));
            }
            case "registrationStatus": {
                return Optional.ofNullable(clazz.cast(this.registrationStatusAsString()));
            }
            case "unregisteredWhatsAppPhoneNumbers": {
                return Optional.ofNullable(clazz.cast(this.unregisteredWhatsAppPhoneNumbers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkedWhatsAppBusinessAccountIdMetaData, T> g) {
        return obj -> g.apply((LinkedWhatsAppBusinessAccountIdMetaData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountName;
        private String registrationStatus;
        private List<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinkedWhatsAppBusinessAccountIdMetaData model) {
            this.accountName(model.accountName);
            this.registrationStatus(model.registrationStatus);
            this.unregisteredWhatsAppPhoneNumbers(model.unregisteredWhatsAppPhoneNumbers);
        }

        public final String getAccountName() {
            return this.accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getRegistrationStatus() {
            return this.registrationStatus;
        }

        public final void setRegistrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
        }

        @Override
        public final Builder registrationStatus(String registrationStatus) {
            this.registrationStatus = registrationStatus;
            return this;
        }

        @Override
        public final Builder registrationStatus(RegistrationStatus registrationStatus) {
            this.registrationStatus(registrationStatus == null ? null : registrationStatus.toString());
            return this;
        }

        public final List<WhatsAppPhoneNumberDetail.Builder> getUnregisteredWhatsAppPhoneNumbers() {
            List<WhatsAppPhoneNumberDetail.Builder> result = WhatsAppPhoneNumberDetailListCopier.copyToBuilder(this.unregisteredWhatsAppPhoneNumbers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnregisteredWhatsAppPhoneNumbers(Collection<WhatsAppPhoneNumberDetail.BuilderImpl> unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers = WhatsAppPhoneNumberDetailListCopier.copyFromBuilder(unregisteredWhatsAppPhoneNumbers);
        }

        @Override
        public final Builder unregisteredWhatsAppPhoneNumbers(Collection<WhatsAppPhoneNumberDetail> unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers = WhatsAppPhoneNumberDetailListCopier.copy(unregisteredWhatsAppPhoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unregisteredWhatsAppPhoneNumbers(WhatsAppPhoneNumberDetail ... unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers(Arrays.asList(unregisteredWhatsAppPhoneNumbers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unregisteredWhatsAppPhoneNumbers(Consumer<WhatsAppPhoneNumberDetail.Builder> ... unregisteredWhatsAppPhoneNumbers) {
            this.unregisteredWhatsAppPhoneNumbers(Stream.of(unregisteredWhatsAppPhoneNumbers).map(c -> (WhatsAppPhoneNumberDetail)((WhatsAppPhoneNumberDetail.Builder)WhatsAppPhoneNumberDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LinkedWhatsAppBusinessAccountIdMetaData build() {
            return new LinkedWhatsAppBusinessAccountIdMetaData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkedWhatsAppBusinessAccountIdMetaData> {
        public Builder accountName(String var1);

        public Builder registrationStatus(String var1);

        public Builder registrationStatus(RegistrationStatus var1);

        public Builder unregisteredWhatsAppPhoneNumbers(Collection<WhatsAppPhoneNumberDetail> var1);

        public Builder unregisteredWhatsAppPhoneNumbers(WhatsAppPhoneNumberDetail ... var1);

        public Builder unregisteredWhatsAppPhoneNumbers(Consumer<WhatsAppPhoneNumberDetail.Builder> ... var1);
    }
}

