/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.socialmessaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.socialmessaging.model.S3File;
import software.amazon.awssdk.services.socialmessaging.model.S3PresignedUrl;
import software.amazon.awssdk.services.socialmessaging.model.SocialMessagingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWhatsAppMessageMediaRequest
extends SocialMessagingRequest
implements ToCopyableBuilder<Builder, GetWhatsAppMessageMediaRequest> {
    private static final SdkField<String> MEDIA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mediaId").getter(GetWhatsAppMessageMediaRequest.getter(GetWhatsAppMessageMediaRequest::mediaId)).setter(GetWhatsAppMessageMediaRequest.setter(Builder::mediaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaId").build()}).build();
    private static final SdkField<String> ORIGINATION_PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originationPhoneNumberId").getter(GetWhatsAppMessageMediaRequest.getter(GetWhatsAppMessageMediaRequest::originationPhoneNumberId)).setter(GetWhatsAppMessageMediaRequest.setter(Builder::originationPhoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originationPhoneNumberId").build()}).build();
    private static final SdkField<Boolean> METADATA_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("metadataOnly").getter(GetWhatsAppMessageMediaRequest.getter(GetWhatsAppMessageMediaRequest::metadataOnly)).setter(GetWhatsAppMessageMediaRequest.setter(Builder::metadataOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataOnly").build()}).build();
    private static final SdkField<S3PresignedUrl> DESTINATION_S3_PRESIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationS3PresignedUrl").getter(GetWhatsAppMessageMediaRequest.getter(GetWhatsAppMessageMediaRequest::destinationS3PresignedUrl)).setter(GetWhatsAppMessageMediaRequest.setter(Builder::destinationS3PresignedUrl)).constructor(S3PresignedUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3PresignedUrl").build()}).build();
    private static final SdkField<S3File> DESTINATION_S3_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationS3File").getter(GetWhatsAppMessageMediaRequest.getter(GetWhatsAppMessageMediaRequest::destinationS3File)).setter(GetWhatsAppMessageMediaRequest.setter(Builder::destinationS3File)).constructor(S3File::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationS3File").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_ID_FIELD, ORIGINATION_PHONE_NUMBER_ID_FIELD, METADATA_ONLY_FIELD, DESTINATION_S3_PRESIGNED_URL_FIELD, DESTINATION_S3_FILE_FIELD));
    private final String mediaId;
    private final String originationPhoneNumberId;
    private final Boolean metadataOnly;
    private final S3PresignedUrl destinationS3PresignedUrl;
    private final S3File destinationS3File;

    private GetWhatsAppMessageMediaRequest(BuilderImpl builder) {
        super(builder);
        this.mediaId = builder.mediaId;
        this.originationPhoneNumberId = builder.originationPhoneNumberId;
        this.metadataOnly = builder.metadataOnly;
        this.destinationS3PresignedUrl = builder.destinationS3PresignedUrl;
        this.destinationS3File = builder.destinationS3File;
    }

    public final String mediaId() {
        return this.mediaId;
    }

    public final String originationPhoneNumberId() {
        return this.originationPhoneNumberId;
    }

    public final Boolean metadataOnly() {
        return this.metadataOnly;
    }

    public final S3PresignedUrl destinationS3PresignedUrl() {
        return this.destinationS3PresignedUrl;
    }

    public final S3File destinationS3File() {
        return this.destinationS3File;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationPhoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3PresignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationS3File());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWhatsAppMessageMediaRequest)) {
            return false;
        }
        GetWhatsAppMessageMediaRequest other = (GetWhatsAppMessageMediaRequest)((Object)obj);
        return Objects.equals(this.mediaId(), other.mediaId()) && Objects.equals(this.originationPhoneNumberId(), other.originationPhoneNumberId()) && Objects.equals(this.metadataOnly(), other.metadataOnly()) && Objects.equals(this.destinationS3PresignedUrl(), other.destinationS3PresignedUrl()) && Objects.equals(this.destinationS3File(), other.destinationS3File());
    }

    public final String toString() {
        return ToString.builder((String)"GetWhatsAppMessageMediaRequest").add("MediaId", (Object)this.mediaId()).add("OriginationPhoneNumberId", (Object)this.originationPhoneNumberId()).add("MetadataOnly", (Object)this.metadataOnly()).add("DestinationS3PresignedUrl", (Object)(this.destinationS3PresignedUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationS3File", (Object)(this.destinationS3File() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "mediaId": {
                return Optional.ofNullable(clazz.cast(this.mediaId()));
            }
            case "originationPhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.originationPhoneNumberId()));
            }
            case "metadataOnly": {
                return Optional.ofNullable(clazz.cast(this.metadataOnly()));
            }
            case "destinationS3PresignedUrl": {
                return Optional.ofNullable(clazz.cast(this.destinationS3PresignedUrl()));
            }
            case "destinationS3File": {
                return Optional.ofNullable(clazz.cast(this.destinationS3File()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWhatsAppMessageMediaRequest, T> g) {
        return obj -> g.apply((GetWhatsAppMessageMediaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SocialMessagingRequest.BuilderImpl
    implements Builder {
        private String mediaId;
        private String originationPhoneNumberId;
        private Boolean metadataOnly;
        private S3PresignedUrl destinationS3PresignedUrl;
        private S3File destinationS3File;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWhatsAppMessageMediaRequest model) {
            super(model);
            this.mediaId(model.mediaId);
            this.originationPhoneNumberId(model.originationPhoneNumberId);
            this.metadataOnly(model.metadataOnly);
            this.destinationS3PresignedUrl(model.destinationS3PresignedUrl);
            this.destinationS3File(model.destinationS3File);
        }

        public final String getMediaId() {
            return this.mediaId;
        }

        public final void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @Override
        public final Builder mediaId(String mediaId) {
            this.mediaId = mediaId;
            return this;
        }

        public final String getOriginationPhoneNumberId() {
            return this.originationPhoneNumberId;
        }

        public final void setOriginationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
        }

        @Override
        public final Builder originationPhoneNumberId(String originationPhoneNumberId) {
            this.originationPhoneNumberId = originationPhoneNumberId;
            return this;
        }

        public final Boolean getMetadataOnly() {
            return this.metadataOnly;
        }

        public final void setMetadataOnly(Boolean metadataOnly) {
            this.metadataOnly = metadataOnly;
        }

        @Override
        public final Builder metadataOnly(Boolean metadataOnly) {
            this.metadataOnly = metadataOnly;
            return this;
        }

        public final S3PresignedUrl.Builder getDestinationS3PresignedUrl() {
            return this.destinationS3PresignedUrl != null ? this.destinationS3PresignedUrl.toBuilder() : null;
        }

        public final void setDestinationS3PresignedUrl(S3PresignedUrl.BuilderImpl destinationS3PresignedUrl) {
            this.destinationS3PresignedUrl = destinationS3PresignedUrl != null ? destinationS3PresignedUrl.build() : null;
        }

        @Override
        public final Builder destinationS3PresignedUrl(S3PresignedUrl destinationS3PresignedUrl) {
            this.destinationS3PresignedUrl = destinationS3PresignedUrl;
            return this;
        }

        public final S3File.Builder getDestinationS3File() {
            return this.destinationS3File != null ? this.destinationS3File.toBuilder() : null;
        }

        public final void setDestinationS3File(S3File.BuilderImpl destinationS3File) {
            this.destinationS3File = destinationS3File != null ? destinationS3File.build() : null;
        }

        @Override
        public final Builder destinationS3File(S3File destinationS3File) {
            this.destinationS3File = destinationS3File;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWhatsAppMessageMediaRequest build() {
            return new GetWhatsAppMessageMediaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SocialMessagingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWhatsAppMessageMediaRequest> {
        public Builder mediaId(String var1);

        public Builder originationPhoneNumberId(String var1);

        public Builder metadataOnly(Boolean var1);

        public Builder destinationS3PresignedUrl(S3PresignedUrl var1);

        default public Builder destinationS3PresignedUrl(Consumer<S3PresignedUrl.Builder> destinationS3PresignedUrl) {
            return this.destinationS3PresignedUrl((S3PresignedUrl)((S3PresignedUrl.Builder)S3PresignedUrl.builder().applyMutation(destinationS3PresignedUrl)).build());
        }

        public Builder destinationS3File(S3File var1);

        default public Builder destinationS3File(Consumer<S3File.Builder> destinationS3File) {
            return this.destinationS3File((S3File)((S3File.Builder)S3File.builder().applyMutation(destinationS3File)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

