/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <fullname>Amazon Simple Notification Service</fullname>
 * <p>
 * Amazon Simple Notification Service (Amazon SNS) is a web service that enables you to build distributed web-enabled
 * applications. Applications can use Amazon SNS to easily push real-time notification messages to interested
 * subscribers over multiple delivery protocols. For more information about this product see the <a
 * href="http://aws.amazon.com/sns/">Amazon SNS product page</a>. For detailed information about Amazon SNS features and
 * their associated API calls, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/">Amazon SNS Developer
 * Guide</a>.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/sns/latest/dg/sns-authentication-and-access-control.html">Identity and access
 * management in Amazon SNS</a> in the <i>Amazon SNS Developer Guide.</i>
 * </p>
 * <p>
 * We also provide SDKs that enable you to access Amazon SNS from your preferred programming language. The SDKs contain
 * functionality that automatically takes care of tasks such as: cryptographically signing your service requests,
 * retrying requests, and handling error responses. For a list of available SDKs, go to <a
 * href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 *
 * <h2>Code Examples</h2>
 * <p>
 * For code examples demonstrating how to use this service with the AWS SDK for Java v2, see:
 * </p>
 * <h3>Getting Started</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Hello_section.html"
 * target="_top">Hello Amazon SNS</a></li>
 * </ul>
 * <h3>API Actions</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetTopicAttributes_section.html"
 * target="_top">Use GetTopicAttributes</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
 * target="_top">Use ListSubscriptions</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
 * target="_top">Use ListTopics</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetSMSAttributes_section.html"
 * target="_top">Use GetSMSAttributes</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ConfirmSubscription_section.html"
 * target="_top">Use ConfirmSubscription</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CheckIfPhoneNumberIsOptedOut_section.html"
 * target="_top">Use CheckIfPhoneNumberIsOptedOut</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_TagResource_section.html"
 * target="_top">Use TagResource</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreateTopic_section.html"
 * target="_top">Use CreateTopic</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_DeleteTopic_section.html"
 * target="_top">Use DeleteTopic</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
 * target="_top">Use ListPhoneNumbersOptedOut</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Publish_section.html"
 * target="_top">Use Publish</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSMSAttributes_section.html"
 * target="_top">Use SetSMSAttributes</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSubscriptionAttributes_section.html"
 * target="_top">Use SetSubscriptionAttributes</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetTopicAttributes_section.html"
 * target="_top">Use SetTopicAttributes</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Subscribe_section.html"
 * target="_top">Use Subscribe</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Unsubscribe_section.html"
 * target="_top">Use Unsubscribe</a></li>
 * </ul>
 * <h3>Scenarios</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_PAM_section.html"
 * target="_top">Create a photo asset management application that lets users manage photos using labels</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_SnsPublishSubscription_section.html"
 * target="_top">Build a publish and subscription application that translates messages</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_SubmitDataApp_section.html"
 * target="_top">Build an application to submit data to a DynamoDB table</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_LambdaAPIGateway_section.html"
 * target="_top">Use API Gateway to invoke a Lambda function</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_LambdaScheduledEvents_section.html"
 * target="_top">Use scheduled events to invoke a Lambda function</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_cross_RekognitionVideoDetection_section.html"
 * target="_top">Detect people and objects in a video with Amazon Rekognition using an AWS SDK</a></li>
 * <li><a
 * href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sqs_Scenario_TopicsAndQueues_section.html"
 * target="_top">Publish Amazon SNS messages to Amazon SQS queues using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_PublishTextSMS_section.html"
 * target="_top">Publish an Amazon SNS SMS text message using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_PublishFifoTopic_section.html"
 * target="_top">Create and publish to a FIFO Amazon SNS topic using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreatePlatformEndpoint_section.html"
 * target="_top">Create a platform endpoint for Amazon SNS push notifications using an AWS SDK</a></li>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_UsageSmsTopic_section.html"
 * target="_top">Publish SMS messages to an Amazon SNS topic using an AWS SDK</a></li>
 * </ul>
 * <h3>Serverless Examples</h3>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_serverless_SNS_Lambda_section.html"
 * target="_top">Invoke a Lambda function from an Amazon SNS trigger</a></li>
 * </ul>
 */
package software.amazon.awssdk.services.sns;