/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.internal.UserAgentUtils;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public class ListSubscriptionsByTopicPublisher
implements SdkPublisher<ListSubscriptionsByTopicResponse> {
    private final SnsAsyncClient client;
    private final ListSubscriptionsByTopicRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSubscriptionsByTopicPublisher(SnsAsyncClient client, ListSubscriptionsByTopicRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSubscriptionsByTopicPublisher(SnsAsyncClient client, ListSubscriptionsByTopicRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSubscriptionsByTopicResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSubscriptionsByTopicResponse> subscriber) {
        subscriber.onSubscribe((org.reactivestreams.Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Subscription> subscriptions() {
        return this.flatMapIterable(response -> response.subscriptions());
    }

    private class ListSubscriptionsByTopicResponseFetcher
    implements AsyncPageFetcher<ListSubscriptionsByTopicResponse> {
        private ListSubscriptionsByTopicResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsByTopicResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSubscriptionsByTopicResponse> nextPage(ListSubscriptionsByTopicResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsByTopicPublisher.this.client.listSubscriptionsByTopic(ListSubscriptionsByTopicPublisher.this.firstRequest);
            }
            return ListSubscriptionsByTopicPublisher.this.client.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)((Object)ListSubscriptionsByTopicPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

