/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;
import software.amazon.awssdk.services.sns.model.AddPermissionResponse;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest;
import software.amazon.awssdk.services.sns.model.ConfirmSubscriptionResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest;
import software.amazon.awssdk.services.sns.model.CreatePlatformEndpointResponse;
import software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.CreateTopicResponse;
import software.amazon.awssdk.services.sns.model.DeleteEndpointRequest;
import software.amazon.awssdk.services.sns.model.DeleteEndpointResponse;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.DeletePlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicResponse;
import software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest;
import software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyResponse;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusRequest;
import software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusResponse;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.GetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest;
import software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest;
import software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.sns.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.sns.model.ListTopicsRequest;
import software.amazon.awssdk.services.sns.model.ListTopicsResponse;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.OptInPhoneNumberResponse;
import software.amazon.awssdk.services.sns.model.PublishBatchRequest;
import software.amazon.awssdk.services.sns.model.PublishBatchResponse;
import software.amazon.awssdk.services.sns.model.PublishRequest;
import software.amazon.awssdk.services.sns.model.PublishResponse;
import software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest;
import software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyResponse;
import software.amazon.awssdk.services.sns.model.RemovePermissionRequest;
import software.amazon.awssdk.services.sns.model.RemovePermissionResponse;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSmsAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesResponse;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest;
import software.amazon.awssdk.services.sns.model.SetTopicAttributesResponse;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.services.sns.model.SubscribeResponse;
import software.amazon.awssdk.services.sns.model.TagResourceRequest;
import software.amazon.awssdk.services.sns.model.TagResourceResponse;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sns.model.UnsubscribeResponse;
import software.amazon.awssdk.services.sns.model.UntagResourceRequest;
import software.amazon.awssdk.services.sns.model.UntagResourceResponse;
import software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest;
import software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberResponse;
import software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPublisher;
import software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersPublisher;
import software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher;
import software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher;
import software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersPublisher;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPublisher;
import software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher;
import software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher;

/**
 * Service client for accessing Amazon SNS asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <fullname>Amazon Simple Notification Service</fullname>
 * <p>
 * Amazon Simple Notification Service (Amazon SNS) is a web service that enables you to build distributed web-enabled
 * applications. Applications can use Amazon SNS to easily push real-time notification messages to interested
 * subscribers over multiple delivery protocols. For more information about this product see the <a
 * href="http://aws.amazon.com/sns/">Amazon SNS product page</a>. For detailed information about Amazon SNS features and
 * their associated API calls, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/">Amazon SNS Developer
 * Guide</a>.
 * </p>
 * <p>
 * For information on the permissions you need to use this API, see <a
 * href="https://docs.aws.amazon.com/sns/latest/dg/sns-authentication-and-access-control.html">Identity and access
 * management in Amazon SNS</a> in the <i>Amazon SNS Developer Guide.</i>
 * </p>
 * <p>
 * We also provide SDKs that enable you to access Amazon SNS from your preferred programming language. The SDKs contain
 * functionality that automatically takes care of tasks such as: cryptographically signing your service requests,
 * retrying requests, and handling error responses. For a list of available SDKs, go to <a
 * href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SnsAsyncClient extends AwsClient {
    String SERVICE_NAME = "sns";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "sns";

    /**
     * <p>
     * Adds a statement to a topic's access control policy, granting access for the specified Amazon Web Services
     * accounts to the specified actions.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note>
     *
     * @param addPermissionRequest
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(AddPermissionRequest addPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a statement to a topic's access control policy, granting access for the specified Amazon Web Services
     * accounts to the specified actions.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddPermissionRequest.Builder} avoiding the need to
     * create one manually via {@link AddPermissionRequest#builder()}
     * </p>
     *
     * @param addPermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.AddPermissionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.AddPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/AddPermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddPermissionResponse> addPermission(Consumer<AddPermissionRequest.Builder> addPermissionRequest) {
        return addPermission(AddPermissionRequest.builder().applyMutation(addPermissionRequest).build());
    }

    /**
     * <p>
     * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your
     * Amazon Web Services account. You cannot send SMS messages to a number that is opted out.
     * </p>
     * <p>
     * To resume sending messages, you can opt in the number by using the <code>OptInPhoneNumber</code> action.
     * </p>
     *
     * @param checkIfPhoneNumberIsOptedOutRequest
     *        The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.
     * @return A Java Future containing the result of the CheckIfPhoneNumberIsOptedOut operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CheckIfPhoneNumberIsOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CheckIfPhoneNumberIsOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CheckIfPhoneNumberIsOptedOutResponse> checkIfPhoneNumberIsOptedOut(
            CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a phone number and indicates whether the phone holder has opted out of receiving SMS messages from your
     * Amazon Web Services account. You cannot send SMS messages to a number that is opted out.
     * </p>
     * <p>
     * To resume sending messages, you can opt in the number by using the <code>OptInPhoneNumber</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CheckIfPhoneNumberIsOptedOutRequest.Builder}
     * avoiding the need to create one manually via {@link CheckIfPhoneNumberIsOptedOutRequest#builder()}
     * </p>
     *
     * @param checkIfPhoneNumberIsOptedOutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest.Builder} to create a
     *        request. The input for the <code>CheckIfPhoneNumberIsOptedOut</code> action.
     * @return A Java Future containing the result of the CheckIfPhoneNumberIsOptedOut operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CheckIfPhoneNumberIsOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CheckIfPhoneNumberIsOptedOut"
     *      target="_top">AWS API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CheckIfPhoneNumberIsOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CheckIfPhoneNumberIsOptedOutResponse> checkIfPhoneNumberIsOptedOut(
            Consumer<CheckIfPhoneNumberIsOptedOutRequest.Builder> checkIfPhoneNumberIsOptedOutRequest) {
        return checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest.builder()
                .applyMutation(checkIfPhoneNumberIsOptedOutRequest).build());
    }

    /**
     * <p>
     * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an
     * earlier <code>Subscribe</code> action. If the token is valid, the action creates a new subscription and returns
     * its Amazon Resource Name (ARN). This call requires an AWS signature only when the
     * <code>AuthenticateOnUnsubscribe</code> flag is set to "true".
     * </p>
     *
     * @param confirmSubscriptionRequest
     *        Input for ConfirmSubscription action.
     * @return A Java Future containing the result of the ConfirmSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ConfirmSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ConfirmSubscription_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ConfirmSubscriptionResponse> confirmSubscription(
            ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies an endpoint owner's intent to receive messages by validating the token sent to the endpoint by an
     * earlier <code>Subscribe</code> action. If the token is valid, the action creates a new subscription and returns
     * its Amazon Resource Name (ARN). This call requires an AWS signature only when the
     * <code>AuthenticateOnUnsubscribe</code> flag is set to "true".
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link ConfirmSubscriptionRequest#builder()}
     * </p>
     *
     * @param confirmSubscriptionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ConfirmSubscriptionRequest.Builder} to create a request.
     *        Input for ConfirmSubscription action.
     * @return A Java Future containing the result of the ConfirmSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ConfirmSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ConfirmSubscription" target="_top">AWS API
     *      Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ConfirmSubscription_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ConfirmSubscriptionResponse> confirmSubscription(
            Consumer<ConfirmSubscriptionRequest.Builder> confirmSubscriptionRequest) {
        return confirmSubscription(ConfirmSubscriptionRequest.builder().applyMutation(confirmSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a platform application object for one of the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify
     * <code>PlatformPrincipal</code> and <code>PlatformCredential</code> attributes when using the
     * <code>CreatePlatformApplication</code> action.
     * </p>
     * <p>
     * <code>PlatformPrincipal</code> and <code>PlatformCredential</code> are received from the notification service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For ADM, <code>PlatformPrincipal</code> is <code>client id</code> and <code>PlatformCredential</code> is
     * <code>client secret</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For APNS and <code>APNS_SANDBOX</code> using certificate credentials, <code>PlatformPrincipal</code> is
     * <code>SSL certificate</code> and <code>PlatformCredential</code> is <code>private key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For APNS and <code>APNS_SANDBOX</code> using token credentials, <code>PlatformPrincipal</code> is
     * <code>signing key ID</code> and <code>PlatformCredential</code> is <code>signing key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Baidu, <code>PlatformPrincipal</code> is <code>API key</code> and <code>PlatformCredential</code> is
     * <code>secret key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging) using key credentials, there is no <code>PlatformPrincipal</code>. The
     * <code>PlatformCredential</code> is <code>API key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging) using token credentials, there is no <code>PlatformPrincipal</code>. The
     * <code>PlatformCredential</code> is a JSON formatted private key file. When using the Amazon Web Services CLI or
     * Amazon Web Services SDKs, the file must be in string format and special characters must be ignored. To format the
     * file correctly, Amazon SNS recommends using the following command:
     * <code>SERVICE_JSON=&#36(jq @json &lt; service.json)</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For MPNS, <code>PlatformPrincipal</code> is <code>TLS certificate</code> and <code>PlatformCredential</code> is
     * <code>private key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For WNS, <code>PlatformPrincipal</code> is <code>Package Security Identifier</code> and
     * <code>PlatformCredential</code> is <code>secret key</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use the returned <code>PlatformApplicationArn</code> as an attribute for the
     * <code>CreatePlatformEndpoint</code> action.
     * </p>
     *
     * @param createPlatformApplicationRequest
     *        Input for CreatePlatformApplication action.
     * @return A Java Future containing the result of the CreatePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreatePlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlatformApplicationResponse> createPlatformApplication(
            CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a platform application object for one of the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging), to which devices and mobile apps may register. You must specify
     * <code>PlatformPrincipal</code> and <code>PlatformCredential</code> attributes when using the
     * <code>CreatePlatformApplication</code> action.
     * </p>
     * <p>
     * <code>PlatformPrincipal</code> and <code>PlatformCredential</code> are received from the notification service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For ADM, <code>PlatformPrincipal</code> is <code>client id</code> and <code>PlatformCredential</code> is
     * <code>client secret</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For APNS and <code>APNS_SANDBOX</code> using certificate credentials, <code>PlatformPrincipal</code> is
     * <code>SSL certificate</code> and <code>PlatformCredential</code> is <code>private key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For APNS and <code>APNS_SANDBOX</code> using token credentials, <code>PlatformPrincipal</code> is
     * <code>signing key ID</code> and <code>PlatformCredential</code> is <code>signing key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For Baidu, <code>PlatformPrincipal</code> is <code>API key</code> and <code>PlatformCredential</code> is
     * <code>secret key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging) using key credentials, there is no <code>PlatformPrincipal</code>. The
     * <code>PlatformCredential</code> is <code>API key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For GCM (Firebase Cloud Messaging) using token credentials, there is no <code>PlatformPrincipal</code>. The
     * <code>PlatformCredential</code> is a JSON formatted private key file. When using the Amazon Web Services CLI or
     * Amazon Web Services SDKs, the file must be in string format and special characters must be ignored. To format the
     * file correctly, Amazon SNS recommends using the following command:
     * <code>SERVICE_JSON=&#36(jq @json &lt; service.json)</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For MPNS, <code>PlatformPrincipal</code> is <code>TLS certificate</code> and <code>PlatformCredential</code> is
     * <code>private key</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * For WNS, <code>PlatformPrincipal</code> is <code>Package Security Identifier</code> and
     * <code>PlatformCredential</code> is <code>secret key</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can use the returned <code>PlatformApplicationArn</code> as an attribute for the
     * <code>CreatePlatformEndpoint</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlatformApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePlatformApplicationRequest#builder()}
     * </p>
     *
     * @param createPlatformApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.CreatePlatformApplicationRequest.Builder} to create a
     *        request. Input for CreatePlatformApplication action.
     * @return A Java Future containing the result of the CreatePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreatePlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlatformApplicationResponse> createPlatformApplication(
            Consumer<CreatePlatformApplicationRequest.Builder> createPlatformApplicationRequest) {
        return createPlatformApplication(CreatePlatformApplicationRequest.builder()
                .applyMutation(createPlatformApplicationRequest).build());
    }

    /**
     * <p>
     * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. <code>CreatePlatformEndpoint</code> requires the
     * <code>PlatformApplicationArn</code> that is returned from <code>CreatePlatformApplication</code>. You can use the
     * returned <code>EndpointArn</code> to send a message to a mobile app or by the <code>Subscribe</code> action for
     * subscription to a topic. The <code>CreatePlatformEndpoint</code> action is idempotent, so if the requester
     * already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without
     * creating a new endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * When using <code>CreatePlatformEndpoint</code> with Baidu, two attributes must be provided: ChannelId and UserId.
     * The token field must also contain the ChannelId. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html">Creating an Amazon SNS Endpoint
     * for Baidu</a>.
     * </p>
     *
     * @param createPlatformEndpointRequest
     *        Input for CreatePlatformEndpoint action.
     * @return A Java Future containing the result of the CreatePlatformEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreatePlatformEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreatePlatformEndpoint_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreatePlatformEndpointResponse> createPlatformEndpoint(
            CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an endpoint for a device and mobile app on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. <code>CreatePlatformEndpoint</code> requires the
     * <code>PlatformApplicationArn</code> that is returned from <code>CreatePlatformApplication</code>. You can use the
     * returned <code>EndpointArn</code> to send a message to a mobile app or by the <code>Subscribe</code> action for
     * subscription to a topic. The <code>CreatePlatformEndpoint</code> action is idempotent, so if the requester
     * already owns an endpoint with the same device token and attributes, that endpoint's ARN is returned without
     * creating a new endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * When using <code>CreatePlatformEndpoint</code> with Baidu, two attributes must be provided: ChannelId and UserId.
     * The token field must also contain the ChannelId. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html">Creating an Amazon SNS Endpoint
     * for Baidu</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlatformEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlatformEndpointRequest#builder()}
     * </p>
     *
     * @param createPlatformEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.CreatePlatformEndpointRequest.Builder} to create a
     *        request. Input for CreatePlatformEndpoint action.
     * @return A Java Future containing the result of the CreatePlatformEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreatePlatformEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreatePlatformEndpoint" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreatePlatformEndpoint_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreatePlatformEndpointResponse> createPlatformEndpoint(
            Consumer<CreatePlatformEndpointRequest.Builder> createPlatformEndpointRequest) {
        return createPlatformEndpoint(CreatePlatformEndpointRequest.builder().applyMutation(createPlatformEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time
     * password (OTP) to that phone number.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     *
     * @param createSmsSandboxPhoneNumberRequest
     * @return A Java Future containing the result of the CreateSMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>OptedOutException Indicates that the specified phone number opted out of receiving SMS messages from
     *         your Amazon Web Services account. You can't send SMS messages to phone numbers that opt out.</li>
     *         <li>UserErrorException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreateSMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateSMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSmsSandboxPhoneNumberResponse> createSMSSandboxPhoneNumber(
            CreateSmsSandboxPhoneNumberRequest createSmsSandboxPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a destination phone number to an Amazon Web Services account in the SMS sandbox and sends a one-time
     * password (OTP) to that phone number.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSmsSandboxPhoneNumberRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSmsSandboxPhoneNumberRequest#builder()}
     * </p>
     *
     * @param createSmsSandboxPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.CreateSmsSandboxPhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>OptedOutException Indicates that the specified phone number opted out of receiving SMS messages from
     *         your Amazon Web Services account. You can't send SMS messages to phone numbers that opt out.</li>
     *         <li>UserErrorException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreateSMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateSMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSmsSandboxPhoneNumberResponse> createSMSSandboxPhoneNumber(
            Consumer<CreateSmsSandboxPhoneNumberRequest.Builder> createSmsSandboxPhoneNumberRequest) {
        return createSMSSandboxPhoneNumber(CreateSmsSandboxPhoneNumberRequest.builder()
                .applyMutation(createSmsSandboxPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at
     * most 1,000 FIFO topics). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html">Creating an Amazon SNS topic</a> in the
     * <i>Amazon SNS Developer Guide</i>. This action is idempotent, so if the requester already owns a topic with the
     * specified name, that topic's ARN is returned without creating a new topic.
     * </p>
     *
     * @param createTopicRequest
     *        Input for CreateTopic action.
     * @return A Java Future containing the result of the CreateTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>TopicLimitExceededException Indicates that the customer already owns the maximum allowed number of
     *         topics.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreateTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreateTopic_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTopicResponse> createTopic(CreateTopicRequest createTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a topic to which notifications can be published. Users can create at most 100,000 standard topics (at
     * most 1,000 FIFO topics). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html">Creating an Amazon SNS topic</a> in the
     * <i>Amazon SNS Developer Guide</i>. This action is idempotent, so if the requester already owns a topic with the
     * specified name, that topic's ARN is returned without creating a new topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTopicRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTopicRequest#builder()}
     * </p>
     *
     * @param createTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.CreateTopicRequest.Builder} to create a request. Input
     *        for CreateTopic action.
     * @return A Java Future containing the result of the CreateTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>TopicLimitExceededException Indicates that the customer already owns the maximum allowed number of
     *         topics.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.CreateTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/CreateTopic" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_CreateTopic_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<CreateTopicResponse> createTopic(Consumer<CreateTopicRequest.Builder> createTopicRequest) {
        return createTopic(CreateTopicRequest.builder().applyMutation(createTopicRequest).build());
    }

    /**
     * <p>
     * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from
     * the topic.
     * </p>
     *
     * @param deleteEndpointRequest
     *        Input for <code>DeleteEndpoint</code> action.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the endpoint for a device and mobile app from Amazon SNS. This action is idempotent. For more
     * information, see <a href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile
     * Push Notifications</a>.
     * </p>
     * <p>
     * When you delete an endpoint that is also subscribed to a topic, then you must also unsubscribe the endpoint from
     * the topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEndpointRequest#builder()}
     * </p>
     *
     * @param deleteEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.DeleteEndpointRequest.Builder} to create a request. Input
     *        for <code>DeleteEndpoint</code> action.
     * @return A Java Future containing the result of the DeleteEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEndpointResponse> deleteEndpoint(Consumer<DeleteEndpointRequest.Builder> deleteEndpointRequest) {
        return deleteEndpoint(DeleteEndpointRequest.builder().applyMutation(deleteEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param deletePlatformApplicationRequest
     *        Input for <code>DeletePlatformApplication</code> action.
     * @return A Java Future containing the result of the DeletePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeletePlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlatformApplicationResponse> deletePlatformApplication(
            DeletePlatformApplicationRequest deletePlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a platform application object for one of the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlatformApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePlatformApplicationRequest#builder()}
     * </p>
     *
     * @param deletePlatformApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.DeletePlatformApplicationRequest.Builder} to create a
     *        request. Input for <code>DeletePlatformApplication</code> action.
     * @return A Java Future containing the result of the DeletePlatformApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeletePlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeletePlatformApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePlatformApplicationResponse> deletePlatformApplication(
            Consumer<DeletePlatformApplicationRequest.Builder> deletePlatformApplicationRequest) {
        return deletePlatformApplication(DeletePlatformApplicationRequest.builder()
                .applyMutation(deletePlatformApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Web Services account's verified or pending phone number from the SMS sandbox.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     *
     * @param deleteSmsSandboxPhoneNumberRequest
     * @return A Java Future containing the result of the DeleteSMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>UserErrorException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteSMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteSMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSmsSandboxPhoneNumberResponse> deleteSMSSandboxPhoneNumber(
            DeleteSmsSandboxPhoneNumberRequest deleteSmsSandboxPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Web Services account's verified or pending phone number from the SMS sandbox.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSmsSandboxPhoneNumberRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSmsSandboxPhoneNumberRequest#builder()}
     * </p>
     *
     * @param deleteSmsSandboxPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.DeleteSmsSandboxPhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>UserErrorException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteSMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteSMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSmsSandboxPhoneNumberResponse> deleteSMSSandboxPhoneNumber(
            Consumer<DeleteSmsSandboxPhoneNumberRequest.Builder> deleteSmsSandboxPhoneNumberRequest) {
        return deleteSMSSandboxPhoneNumber(DeleteSmsSandboxPhoneNumberRequest.builder()
                .applyMutation(deleteSmsSandboxPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the
     * topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist
     * does not result in an error.
     * </p>
     *
     * @param deleteTopicRequest
     * @return A Java Future containing the result of the DeleteTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidStateException Indicates that the specified state is not a valid state for an event source.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_DeleteTopic_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTopicResponse> deleteTopic(DeleteTopicRequest deleteTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a topic and all its subscriptions. Deleting a topic might prevent some messages previously sent to the
     * topic from being delivered to subscribers. This action is idempotent, so deleting a topic that does not exist
     * does not result in an error.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTopicRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTopicRequest#builder()}
     * </p>
     *
     * @param deleteTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.DeleteTopicRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidStateException Indicates that the specified state is not a valid state for an event source.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.DeleteTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/DeleteTopic" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_DeleteTopic_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<DeleteTopicResponse> deleteTopic(Consumer<DeleteTopicRequest.Builder> deleteTopicRequest) {
        return deleteTopic(DeleteTopicRequest.builder().applyMutation(deleteTopicRequest).build());
    }

    /**
     * <p>
     * Retrieves the specified inline <code>DataProtectionPolicy</code> document that is stored in the specified Amazon
     * SNS topic.
     * </p>
     *
     * @param getDataProtectionPolicyRequest
     * @return A Java Future containing the result of the GetDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataProtectionPolicyResponse> getDataProtectionPolicy(
            GetDataProtectionPolicyRequest getDataProtectionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the specified inline <code>DataProtectionPolicy</code> document that is stored in the specified Amazon
     * SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataProtectionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataProtectionPolicyRequest#builder()}
     * </p>
     *
     * @param getDataProtectionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetDataProtectionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDataProtectionPolicyResponse> getDataProtectionPolicy(
            Consumer<GetDataProtectionPolicyRequest.Builder> getDataProtectionPolicyRequest) {
        return getDataProtectionPolicy(GetDataProtectionPolicyRequest.builder().applyMutation(getDataProtectionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param getEndpointAttributesRequest
     *        Input for <code>GetEndpointAttributes</code> action.
     * @return A Java Future containing the result of the GetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetEndpointAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointAttributesResponse> getEndpointAttributes(
            GetEndpointAttributesRequest getEndpointAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the endpoint attributes for a device on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEndpointAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetEndpointAttributesRequest#builder()}
     * </p>
     *
     * @param getEndpointAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetEndpointAttributesRequest.Builder} to create a
     *        request. Input for <code>GetEndpointAttributes</code> action.
     * @return A Java Future containing the result of the GetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetEndpointAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEndpointAttributesResponse> getEndpointAttributes(
            Consumer<GetEndpointAttributesRequest.Builder> getEndpointAttributesRequest) {
        return getEndpointAttributes(GetEndpointAttributesRequest.builder().applyMutation(getEndpointAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the attributes of the platform application object for the supported push notification services, such as
     * APNS and GCM (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param getPlatformApplicationAttributesRequest
     *        Input for <code>GetPlatformApplicationAttributes</code> action.
     * @return A Java Future containing the result of the GetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetPlatformApplicationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlatformApplicationAttributesResponse> getPlatformApplicationAttributes(
            GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the attributes of the platform application object for the supported push notification services, such as
     * APNS and GCM (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlatformApplicationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link GetPlatformApplicationAttributesRequest#builder()}
     * </p>
     *
     * @param getPlatformApplicationAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetPlatformApplicationAttributesRequest.Builder} to
     *        create a request. Input for <code>GetPlatformApplicationAttributes</code> action.
     * @return A Java Future containing the result of the GetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetPlatformApplicationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPlatformApplicationAttributesResponse> getPlatformApplicationAttributes(
            Consumer<GetPlatformApplicationAttributesRequest.Builder> getPlatformApplicationAttributesRequest) {
        return getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest.builder()
                .applyMutation(getPlatformApplicationAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your Amazon Web Services account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     *
     * @param getSmsAttributesRequest
     *        The input for the <code>GetSMSAttributes</code> request.
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSMSAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetSMSAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetSmsAttributesResponse> getSMSAttributes(GetSmsAttributesRequest getSmsAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your Amazon Web Services account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSmsAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link GetSmsAttributesRequest#builder()}
     * </p>
     *
     * @param getSmsAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetSmsAttributesRequest.Builder} to create a request. The
     *        input for the <code>GetSMSAttributes</code> request.
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSMSAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetSMSAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetSmsAttributesResponse> getSMSAttributes(
            Consumer<GetSmsAttributesRequest.Builder> getSmsAttributesRequest) {
        return getSMSAttributes(GetSmsAttributesRequest.builder().applyMutation(getSmsAttributesRequest).build());
    }

    /**
     * <p>
     * Returns the settings for sending SMS messages from your Amazon Web Services account.
     * </p>
     * <p>
     * These settings are set with the <code>SetSMSAttributes</code> action.
     * </p>
     *
     * @return A Java Future containing the result of the GetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSMSAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetSMSAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetSmsAttributesResponse> getSMSAttributes() {
        return getSMSAttributes(GetSmsAttributesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services
     * Region.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     *
     * @param getSmsSandboxAccountStatusRequest
     * @return A Java Future containing the result of the GetSMSSandboxAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSMSSandboxAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSSandboxAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSmsSandboxAccountStatusResponse> getSMSSandboxAccountStatus(
            GetSmsSandboxAccountStatusRequest getSmsSandboxAccountStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the SMS sandbox status for the calling Amazon Web Services account in the target Amazon Web Services
     * Region.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSmsSandboxAccountStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetSmsSandboxAccountStatusRequest#builder()}
     * </p>
     *
     * @param getSmsSandboxAccountStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetSmsSandboxAccountStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSMSSandboxAccountStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSMSSandboxAccountStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSMSSandboxAccountStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSmsSandboxAccountStatusResponse> getSMSSandboxAccountStatus(
            Consumer<GetSmsSandboxAccountStatusRequest.Builder> getSmsSandboxAccountStatusRequest) {
        return getSMSSandboxAccountStatus(GetSmsSandboxAccountStatusRequest.builder()
                .applyMutation(getSmsSandboxAccountStatusRequest).build());
    }

    /**
     * <p>
     * Returns all of the properties of a subscription.
     * </p>
     *
     * @param getSubscriptionAttributesRequest
     *        Input for GetSubscriptionAttributes.
     * @return A Java Future containing the result of the GetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSubscriptionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionAttributesResponse> getSubscriptionAttributes(
            GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the properties of a subscription.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link GetSubscriptionAttributesRequest#builder()}
     * </p>
     *
     * @param getSubscriptionAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetSubscriptionAttributesRequest.Builder} to create a
     *        request. Input for GetSubscriptionAttributes.
     * @return A Java Future containing the result of the GetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetSubscriptionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSubscriptionAttributesResponse> getSubscriptionAttributes(
            Consumer<GetSubscriptionAttributesRequest.Builder> getSubscriptionAttributesRequest) {
        return getSubscriptionAttributes(GetSubscriptionAttributesRequest.builder()
                .applyMutation(getSubscriptionAttributesRequest).build());
    }

    /**
     * <p>
     * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of
     * the user.
     * </p>
     *
     * @param getTopicAttributesRequest
     *        Input for GetTopicAttributes action.
     * @return A Java Future containing the result of the GetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetTopicAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetTopicAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetTopicAttributesResponse> getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all of the properties of a topic. Topic properties returned might differ based on the authorization of
     * the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTopicAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link GetTopicAttributesRequest#builder()}
     * </p>
     *
     * @param getTopicAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.GetTopicAttributesRequest.Builder} to create a request.
     *        Input for GetTopicAttributes action.
     * @return A Java Future containing the result of the GetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.GetTopicAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_GetTopicAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<GetTopicAttributesResponse> getTopicAttributes(
            Consumer<GetTopicAttributesRequest.Builder> getTopicAttributesRequest) {
        return getTopicAttributes(GetTopicAttributesRequest.builder().applyMutation(getTopicAttributesRequest).build());
    }

    /**
     * <p>
     * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM
     * (Firebase Cloud Messaging) and APNS. The results for <code>ListEndpointsByPlatformApplication</code> are
     * paginated and return a limited list of endpoints, up to 100. If additional records are available after the first
     * page results, then a NextToken string will be returned. To receive the next page, you call
     * <code>ListEndpointsByPlatformApplication</code> again using the NextToken string received from the previous call.
     * When there are no more records to return, NextToken will be null. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        Input for <code>ListEndpointsByPlatformApplication</code> action.
     * @return A Java Future containing the result of the ListEndpointsByPlatformApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointsByPlatformApplicationResponse> listEndpointsByPlatformApplication(
            ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the endpoints and endpoint attributes for devices in a supported push notification service, such as GCM
     * (Firebase Cloud Messaging) and APNS. The results for <code>ListEndpointsByPlatformApplication</code> are
     * paginated and return a limited list of endpoints, up to 100. If additional records are available after the first
     * page results, then a NextToken string will be returned. To receive the next page, you call
     * <code>ListEndpointsByPlatformApplication</code> again using the NextToken string received from the previous call.
     * When there are no more records to return, NextToken will be null. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsByPlatformApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListEndpointsByPlatformApplicationRequest#builder()}
     * </p>
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest.Builder} to
     *        create a request. Input for <code>ListEndpointsByPlatformApplication</code> action.
     * @return A Java Future containing the result of the ListEndpointsByPlatformApplication operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEndpointsByPlatformApplicationResponse> listEndpointsByPlatformApplication(
            Consumer<ListEndpointsByPlatformApplicationRequest.Builder> listEndpointsByPlatformApplicationRequest) {
        return listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest.builder()
                .applyMutation(listEndpointsByPlatformApplicationRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEndpointsByPlatformApplication(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPublisher publisher = client.listEndpointsByPlatformApplicationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPublisher publisher = client.listEndpointsByPlatformApplicationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointsByPlatformApplication(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        Input for <code>ListEndpointsByPlatformApplication</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointsByPlatformApplicationPublisher listEndpointsByPlatformApplicationPaginator(
            ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) {
        return new ListEndpointsByPlatformApplicationPublisher(this, listEndpointsByPlatformApplicationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEndpointsByPlatformApplication(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPublisher publisher = client.listEndpointsByPlatformApplicationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListEndpointsByPlatformApplicationPublisher publisher = client.listEndpointsByPlatformApplicationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEndpointsByPlatformApplication(software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEndpointsByPlatformApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListEndpointsByPlatformApplicationRequest#builder()}
     * </p>
     *
     * @param listEndpointsByPlatformApplicationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest.Builder} to
     *        create a request. Input for <code>ListEndpointsByPlatformApplication</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListEndpointsByPlatformApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListEndpointsByPlatformApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEndpointsByPlatformApplicationPublisher listEndpointsByPlatformApplicationPaginator(
            Consumer<ListEndpointsByPlatformApplicationRequest.Builder> listEndpointsByPlatformApplicationRequest) {
        return listEndpointsByPlatformApplicationPaginator(ListEndpointsByPlatformApplicationRequest.builder()
                .applyMutation(listEndpointsByPlatformApplicationRequest).build());
    }

    /**
     * <p>
     * Lists the calling Amazon Web Services account's dedicated origination numbers and their metadata. For more
     * information about origination numbers, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html"
     * >Origination numbers</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     *
     * @param listOriginationNumbersRequest
     * @return A Java Future containing the result of the ListOriginationNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListOriginationNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListOriginationNumbers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOriginationNumbersResponse> listOriginationNumbers(
            ListOriginationNumbersRequest listOriginationNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the calling Amazon Web Services account's dedicated origination numbers and their metadata. For more
     * information about origination numbers, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/channels-sms-originating-identities-origination-numbers.html"
     * >Origination numbers</a> in the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginationNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginationNumbersRequest#builder()}
     * </p>
     *
     * @param listOriginationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListOriginationNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListOriginationNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListOriginationNumbers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListOriginationNumbersResponse> listOriginationNumbers(
            Consumer<ListOriginationNumbersRequest.Builder> listOriginationNumbersRequest) {
        return listOriginationNumbers(ListOriginationNumbersRequest.builder().applyMutation(listOriginationNumbersRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOriginationNumbers(software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersPublisher publisher = client.listOriginationNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersPublisher publisher = client.listOriginationNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginationNumbers(software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOriginationNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListOriginationNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListOriginationNumbers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOriginationNumbersPublisher listOriginationNumbersPaginator(
            ListOriginationNumbersRequest listOriginationNumbersRequest) {
        return new ListOriginationNumbersPublisher(this, listOriginationNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOriginationNumbers(software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersPublisher publisher = client.listOriginationNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListOriginationNumbersPublisher publisher = client.listOriginationNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListOriginationNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOriginationNumbers(software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOriginationNumbersRequest.Builder} avoiding the
     * need to create one manually via {@link ListOriginationNumbersRequest#builder()}
     * </p>
     *
     * @param listOriginationNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListOriginationNumbersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListOriginationNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListOriginationNumbers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListOriginationNumbersPublisher listOriginationNumbersPaginator(
            Consumer<ListOriginationNumbersRequest.Builder> listOriginationNumbersRequest) {
        return listOriginationNumbersPaginator(ListOriginationNumbersRequest.builder()
                .applyMutation(listOriginationNumbersRequest).build());
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     *
     * @param listPhoneNumbersOptedOutRequest
     *        The input for the <code>ListPhoneNumbersOptedOut</code> action.
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut(
            ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersOptedOutRequest.Builder} avoiding
     * the need to create one manually via {@link ListPhoneNumbersOptedOutRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersOptedOutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest.Builder} to create a
     *        request. The input for the <code>ListPhoneNumbersOptedOut</code> action.
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut(
            Consumer<ListPhoneNumbersOptedOutRequest.Builder> listPhoneNumbersOptedOutRequest) {
        return listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest.builder().applyMutation(listPhoneNumbersOptedOutRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of phone numbers that are opted out, meaning you cannot send SMS messages to them.
     * </p>
     * <p>
     * The results for <code>ListPhoneNumbersOptedOut</code> are paginated, and each page returns up to 100 phone
     * numbers. If additional phone numbers are available after the first page of results, then a <code>NextToken</code>
     * string will be returned. To receive the next page, you call <code>ListPhoneNumbersOptedOut</code> again using the
     * <code>NextToken</code> string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null.
     * </p>
     *
     * @return A Java Future containing the result of the ListPhoneNumbersOptedOut operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListPhoneNumbersOptedOutResponse> listPhoneNumbersOptedOut() {
        return listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default ListPhoneNumbersOptedOutPublisher listPhoneNumbersOptedOutPaginator() {
        return listPhoneNumbersOptedOutPaginator(ListPhoneNumbersOptedOutRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPhoneNumbersOptedOutRequest
     *        The input for the <code>ListPhoneNumbersOptedOut</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default ListPhoneNumbersOptedOutPublisher listPhoneNumbersOptedOutPaginator(
            ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) {
        return new ListPhoneNumbersOptedOutPublisher(this, listPhoneNumbersOptedOutRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPhoneNumbersOptedOutPublisher publisher = client.listPhoneNumbersOptedOutPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPhoneNumbersOptedOut(software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPhoneNumbersOptedOutRequest.Builder} avoiding
     * the need to create one manually via {@link ListPhoneNumbersOptedOutRequest#builder()}
     * </p>
     *
     * @param listPhoneNumbersOptedOutRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListPhoneNumbersOptedOutRequest.Builder} to create a
     *        request. The input for the <code>ListPhoneNumbersOptedOut</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPhoneNumbersOptedOut
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPhoneNumbersOptedOut" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListPhoneNumbersOptedOut_section.html"
     *      target="_top">Code Example</a>
     */
    default ListPhoneNumbersOptedOutPublisher listPhoneNumbersOptedOutPaginator(
            Consumer<ListPhoneNumbersOptedOutRequest.Builder> listPhoneNumbersOptedOutRequest) {
        return listPhoneNumbersOptedOutPaginator(ListPhoneNumbersOptedOutRequest.builder()
                .applyMutation(listPhoneNumbersOptedOutRequest).build());
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging). The results for <code>ListPlatformApplications</code> are paginated and return a
     * limited list of applications, up to 100. If additional records are available after the first page results, then a
     * NextToken string will be returned. To receive the next page, you call <code>ListPlatformApplications</code> using
     * the NextToken string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * This action is throttled at 15 transactions per second (TPS).
     * </p>
     *
     * @param listPlatformApplicationsRequest
     *        Input for <code>ListPlatformApplications</code> action.
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications(
            ListPlatformApplicationsRequest listPlatformApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging). The results for <code>ListPlatformApplications</code> are paginated and return a
     * limited list of applications, up to 100. If additional records are available after the first page results, then a
     * NextToken string will be returned. To receive the next page, you call <code>ListPlatformApplications</code> using
     * the NextToken string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * This action is throttled at 15 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlatformApplicationsRequest#builder()}
     * </p>
     *
     * @param listPlatformApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest.Builder} to create a
     *        request. Input for <code>ListPlatformApplications</code> action.
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications(
            Consumer<ListPlatformApplicationsRequest.Builder> listPlatformApplicationsRequest) {
        return listPlatformApplications(ListPlatformApplicationsRequest.builder().applyMutation(listPlatformApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the platform application objects for the supported push notification services, such as APNS and GCM
     * (Firebase Cloud Messaging). The results for <code>ListPlatformApplications</code> are paginated and return a
     * limited list of applications, up to 100. If additional records are available after the first page results, then a
     * NextToken string will be returned. To receive the next page, you call <code>ListPlatformApplications</code> using
     * the NextToken string received from the previous call. When there are no more records to return,
     * <code>NextToken</code> will be null. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <p>
     * This action is throttled at 15 transactions per second (TPS).
     * </p>
     *
     * @return A Java Future containing the result of the ListPlatformApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPlatformApplicationsResponse> listPlatformApplications() {
        return listPlatformApplications(ListPlatformApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPlatformApplicationsPublisher listPlatformApplicationsPaginator() {
        return listPlatformApplicationsPaginator(ListPlatformApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlatformApplicationsRequest
     *        Input for <code>ListPlatformApplications</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPlatformApplicationsPublisher listPlatformApplicationsPaginator(
            ListPlatformApplicationsRequest listPlatformApplicationsRequest) {
        return new ListPlatformApplicationsPublisher(this, listPlatformApplicationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListPlatformApplicationsPublisher publisher = client.listPlatformApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlatformApplications(software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlatformApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPlatformApplicationsRequest#builder()}
     * </p>
     *
     * @param listPlatformApplicationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest.Builder} to create a
     *        request. Input for <code>ListPlatformApplications</code> action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListPlatformApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListPlatformApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPlatformApplicationsPublisher listPlatformApplicationsPaginator(
            Consumer<ListPlatformApplicationsRequest.Builder> listPlatformApplicationsRequest) {
        return listPlatformApplicationsPaginator(ListPlatformApplicationsRequest.builder()
                .applyMutation(listPlatformApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists the calling Amazon Web Services account's current verified and pending destination phone numbers in the SMS
     * sandbox.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     *
     * @param listSmsSandboxPhoneNumbersRequest
     * @return A Java Future containing the result of the ListSMSSandboxPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSMSSandboxPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSMSSandboxPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSmsSandboxPhoneNumbersResponse> listSMSSandboxPhoneNumbers(
            ListSmsSandboxPhoneNumbersRequest listSmsSandboxPhoneNumbersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the calling Amazon Web Services account's current verified and pending destination phone numbers in the SMS
     * sandbox.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmsSandboxPhoneNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmsSandboxPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listSmsSandboxPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSMSSandboxPhoneNumbers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSMSSandboxPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSMSSandboxPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSmsSandboxPhoneNumbersResponse> listSMSSandboxPhoneNumbers(
            Consumer<ListSmsSandboxPhoneNumbersRequest.Builder> listSmsSandboxPhoneNumbersRequest) {
        return listSMSSandboxPhoneNumbers(ListSmsSandboxPhoneNumbersRequest.builder()
                .applyMutation(listSmsSandboxPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSMSSandboxPhoneNumbers(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersPublisher publisher = client.listSMSSandboxPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersPublisher publisher = client.listSMSSandboxPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSMSSandboxPhoneNumbers(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSmsSandboxPhoneNumbersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSMSSandboxPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSMSSandboxPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSMSSandboxPhoneNumbersPublisher listSMSSandboxPhoneNumbersPaginator(
            ListSmsSandboxPhoneNumbersRequest listSmsSandboxPhoneNumbersRequest) {
        return new ListSMSSandboxPhoneNumbersPublisher(this, listSmsSandboxPhoneNumbersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSMSSandboxPhoneNumbers(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersPublisher publisher = client.listSMSSandboxPhoneNumbersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSMSSandboxPhoneNumbersPublisher publisher = client.listSMSSandboxPhoneNumbersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSMSSandboxPhoneNumbers(software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSmsSandboxPhoneNumbersRequest.Builder} avoiding
     * the need to create one manually via {@link ListSmsSandboxPhoneNumbersRequest#builder()}
     * </p>
     *
     * @param listSmsSandboxPhoneNumbersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSmsSandboxPhoneNumbersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSMSSandboxPhoneNumbers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSMSSandboxPhoneNumbers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSMSSandboxPhoneNumbersPublisher listSMSSandboxPhoneNumbersPaginator(
            Consumer<ListSmsSandboxPhoneNumbersRequest.Builder> listSmsSandboxPhoneNumbersRequest) {
        return listSMSSandboxPhoneNumbersPaginator(ListSmsSandboxPhoneNumbersRequest.builder()
                .applyMutation(listSmsSandboxPhoneNumbersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @param listSubscriptionsRequest
     *        Input for ListSubscriptions action.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest.Builder} to create a request.
     *        Input for ListSubscriptions action.
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptions(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's subscriptions. Each call returns a limited list of subscriptions, up to 100. If
     * there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter
     * in a new <code>ListSubscriptions</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @return A Java Future containing the result of the ListSubscriptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListSubscriptionsResponse> listSubscriptions() {
        return listSubscriptions(ListSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to
     * 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code>
     * parameter in a new <code>ListSubscriptionsByTopic</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @param listSubscriptionsByTopicRequest
     *        Input for ListSubscriptionsByTopic action.
     * @return A Java Future containing the result of the ListSubscriptionsByTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptionsByTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsByTopicResponse> listSubscriptionsByTopic(
            ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the subscriptions to a specific topic. Each call returns a limited list of subscriptions, up to
     * 100. If there are more subscriptions, a <code>NextToken</code> is also returned. Use the <code>NextToken</code>
     * parameter in a new <code>ListSubscriptionsByTopic</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsByTopicRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionsByTopicRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsByTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest.Builder} to create a
     *        request. Input for ListSubscriptionsByTopic action.
     * @return A Java Future containing the result of the ListSubscriptionsByTopic operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptionsByTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSubscriptionsByTopicResponse> listSubscriptionsByTopic(
            Consumer<ListSubscriptionsByTopicRequest.Builder> listSubscriptionsByTopicRequest) {
        return listSubscriptionsByTopic(ListSubscriptionsByTopicRequest.builder().applyMutation(listSubscriptionsByTopicRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionsByTopic(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPublisher publisher = client.listSubscriptionsByTopicPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPublisher publisher = client.listSubscriptionsByTopicPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionsByTopic(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSubscriptionsByTopicRequest
     *        Input for ListSubscriptionsByTopic action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptionsByTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsByTopicPublisher listSubscriptionsByTopicPaginator(
            ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) {
        return new ListSubscriptionsByTopicPublisher(this, listSubscriptionsByTopicRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptionsByTopic(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPublisher publisher = client.listSubscriptionsByTopicPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsByTopicPublisher publisher = client.listSubscriptionsByTopicPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptionsByTopic(software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsByTopicRequest.Builder} avoiding
     * the need to create one manually via {@link ListSubscriptionsByTopicRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsByTopicRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest.Builder} to create a
     *        request. Input for ListSubscriptionsByTopic action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptionsByTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptionsByTopic" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSubscriptionsByTopicPublisher listSubscriptionsByTopicPaginator(
            Consumer<ListSubscriptionsByTopicRequest.Builder> listSubscriptionsByTopicRequest) {
        return listSubscriptionsByTopicPaginator(ListSubscriptionsByTopicRequest.builder()
                .applyMutation(listSubscriptionsByTopicRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator() {
        return listSubscriptionsPaginator(ListSubscriptionsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation.</b>
     * </p>
     *
     * @param listSubscriptionsRequest
     *        Input for ListSubscriptions action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(ListSubscriptionsRequest listSubscriptionsRequest) {
        return new ListSubscriptionsPublisher(this, listSubscriptionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListSubscriptionsPublisher publisher = client.listSubscriptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSubscriptions(software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSubscriptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListSubscriptionsRequest#builder()}
     * </p>
     *
     * @param listSubscriptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest.Builder} to create a request.
     *        Input for ListSubscriptions action.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListSubscriptions" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListSubscriptions_section.html"
     *      target="_top">Code Example</a>
     */
    default ListSubscriptionsPublisher listSubscriptionsPaginator(
            Consumer<ListSubscriptionsRequest.Builder> listSubscriptionsRequest) {
        return listSubscriptionsPaginator(ListSubscriptionsRequest.builder().applyMutation(listSubscriptionsRequest).build());
    }

    /**
     * <p>
     * List all tags added to the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon Simple
     * Notification Service Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags added to the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon Simple
     * Notification Service Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @param listTopicsRequest
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics(ListTopicsRequest listTopicsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTopicsRequest#builder()}
     * </p>
     *
     * @param listTopicsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListTopicsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics(Consumer<ListTopicsRequest.Builder> listTopicsRequest) {
        return listTopics(ListTopicsRequest.builder().applyMutation(listTopicsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the requester's topics. Each call returns a limited list of topics, up to 100. If there are
     * more topics, a <code>NextToken</code> is also returned. Use the <code>NextToken</code> parameter in a new
     * <code>ListTopics</code> call to get further results.
     * </p>
     * <p>
     * This action is throttled at 30 transactions per second (TPS).
     * </p>
     *
     * @return A Java Future containing the result of the ListTopics operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<ListTopicsResponse> listTopics() {
        return listTopics(ListTopicsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListTopicsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListTopicsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTopicsPublisher listTopicsPaginator() {
        return listTopicsPaginator(ListTopicsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListTopicsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListTopicsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.</b>
     * </p>
     *
     * @param listTopicsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTopicsPublisher listTopicsPaginator(ListTopicsRequest listTopicsRequest) {
        return new ListTopicsPublisher(this, listTopicsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.sns.paginators.ListTopicsPublisher publisher = client.listTopicsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.sns.model.ListTopicsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.sns.model.ListTopicsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTopics(software.amazon.awssdk.services.sns.model.ListTopicsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTopicsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTopicsRequest#builder()}
     * </p>
     *
     * @param listTopicsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.ListTopicsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.ListTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/ListTopics" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_ListTopics_section.html"
     *      target="_top">Code Example</a>
     */
    default ListTopicsPublisher listTopicsPaginator(Consumer<ListTopicsRequest.Builder> listTopicsRequest) {
        return listTopicsPaginator(ListTopicsRequest.builder().applyMutation(listTopicsRequest).build());
    }

    /**
     * <p>
     * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to
     * the number.
     * </p>
     * <p>
     * You can opt in a phone number only once every 30 days.
     * </p>
     *
     * @param optInPhoneNumberRequest
     *        Input for the OptInPhoneNumber action.
     * @return A Java Future containing the result of the OptInPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.OptInPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptInPhoneNumberResponse> optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this request to opt in a phone number that is opted out, which enables you to resume sending SMS messages to
     * the number.
     * </p>
     * <p>
     * You can opt in a phone number only once every 30 days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link OptInPhoneNumberRequest.Builder} avoiding the need
     * to create one manually via {@link OptInPhoneNumberRequest#builder()}
     * </p>
     *
     * @param optInPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.OptInPhoneNumberRequest.Builder} to create a request.
     *        Input for the OptInPhoneNumber action.
     * @return A Java Future containing the result of the OptInPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.OptInPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/OptInPhoneNumber" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<OptInPhoneNumberResponse> optInPhoneNumber(
            Consumer<OptInPhoneNumberRequest.Builder> optInPhoneNumberRequest) {
        return optInPhoneNumber(OptInPhoneNumberRequest.builder().applyMutation(optInPhoneNumberRequest).build());
    }

    /**
     * <p>
     * Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to
     * a mobile platform endpoint (when you specify the <code>TargetArn</code>).
     * </p>
     * <p>
     * If you send a message to a topic, Amazon SNS delivers the message to each endpoint that is subscribed to the
     * topic. The format of the message depends on the notification protocol for each subscribed endpoint.
     * </p>
     * <p>
     * When a <code>messageId</code> is returned, the message is saved and Amazon SNS immediately delivers it to
     * subscribers.
     * </p>
     * <p>
     * To use the <code>Publish</code> action for publishing a message to a mobile endpoint, such as an app on a Kindle
     * device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned
     * when making a call with the <code>CreatePlatformEndpoint</code> action.
     * </p>
     * <p>
     * For more information about formatting messages, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html">Send Custom
     * Platform-Specific Payloads in Messages to Mobile Devices</a>.
     * </p>
     * <important>
     * <p>
     * You can publish messages only to topics and endpoints in the same Amazon Web Services Region.
     * </p>
     * </important>
     *
     * @param publishRequest
     *        Input for Publish action.
     * @return A Java Future containing the result of the Publish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>KmsDisabledException The request was rejected because the specified Amazon Web Services KMS key isn't
     *         enabled.</li>
     *         <li>KmsInvalidStateException The request was rejected because the state of the specified resource isn't
     *         valid for this request. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web
     *         Services KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</li>
     *         <li>KmsNotFoundException The request was rejected because the specified entity or resource can't be
     *         found.</li>
     *         <li>KmsOptInRequiredException The Amazon Web Services access key ID needs a subscription for the service.
     *         </li>
     *         <li>KmsThrottlingException The request was denied due to request throttling. For more information about
     *         throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>Key Management Service Developer Guide.</i></li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that you don't have
     *         access to.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Publish
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Publish_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<PublishResponse> publish(PublishRequest publishRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sends a message to an Amazon SNS topic, a text message (SMS message) directly to a phone number, or a message to
     * a mobile platform endpoint (when you specify the <code>TargetArn</code>).
     * </p>
     * <p>
     * If you send a message to a topic, Amazon SNS delivers the message to each endpoint that is subscribed to the
     * topic. The format of the message depends on the notification protocol for each subscribed endpoint.
     * </p>
     * <p>
     * When a <code>messageId</code> is returned, the message is saved and Amazon SNS immediately delivers it to
     * subscribers.
     * </p>
     * <p>
     * To use the <code>Publish</code> action for publishing a message to a mobile endpoint, such as an app on a Kindle
     * device or mobile phone, you must specify the EndpointArn for the TargetArn parameter. The EndpointArn is returned
     * when making a call with the <code>CreatePlatformEndpoint</code> action.
     * </p>
     * <p>
     * For more information about formatting messages, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/mobile-push-send-custommessage.html">Send Custom
     * Platform-Specific Payloads in Messages to Mobile Devices</a>.
     * </p>
     * <important>
     * <p>
     * You can publish messages only to topics and endpoints in the same Amazon Web Services Region.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishRequest.Builder} avoiding the need to create
     * one manually via {@link PublishRequest#builder()}
     * </p>
     *
     * @param publishRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.PublishRequest.Builder} to create a request. Input for
     *        Publish action.
     * @return A Java Future containing the result of the Publish operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>KmsDisabledException The request was rejected because the specified Amazon Web Services KMS key isn't
     *         enabled.</li>
     *         <li>KmsInvalidStateException The request was rejected because the state of the specified resource isn't
     *         valid for this request. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web
     *         Services KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</li>
     *         <li>KmsNotFoundException The request was rejected because the specified entity or resource can't be
     *         found.</li>
     *         <li>KmsOptInRequiredException The Amazon Web Services access key ID needs a subscription for the service.
     *         </li>
     *         <li>KmsThrottlingException The request was denied due to request throttling. For more information about
     *         throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>Key Management Service Developer Guide.</i></li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that you don't have
     *         access to.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Publish
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Publish" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Publish_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<PublishResponse> publish(Consumer<PublishRequest.Builder> publishRequest) {
        return publish(PublishRequest.builder().applyMutation(publishRequest).build());
    }

    /**
     * <p>
     * Publishes up to 10 messages to the specified topic in a single batch. This is a batch version of the
     * <code>Publish</code> API. If you try to send more than 10 messages in a single batch request, you will receive a
     * <code>TooManyEntriesInBatchRequest</code> exception.
     * </p>
     * <p>
     * For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages
     * are deduplicated within the batch and across batches for five minutes.
     * </p>
     * <p>
     * The result of publishing each message is reported individually in the response. Because the batch request can
     * result in a combination of successful and unsuccessful actions, you should check for batch errors even when the
     * call returns an HTTP status code of 200.
     * </p>
     * <p>
     * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths
     * of all of the batched messages) are both 256 KB (262,144 bytes).
     * </p>
     * <important>
     * <p>
     * The <code>PublishBatch</code> API can send up to 10 messages at a time. If you attempt to send more than 10
     * messages in one request, you will encounter a <code>TooManyEntriesInBatchRequest</code> exception. In such cases,
     * split your messages into multiple requests, each containing no more than 10 messages.
     * </p>
     * </important>
     * <p>
     * Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values
     * of <code>n</code> are integers starting from <b>1</b>. For example, a parameter list with two elements looks like
     * this:
     * </p>
     * <p>
     * <code>&amp;AttributeName.1=first</code>
     * </p>
     * <p>
     * <code>&amp;AttributeName.2=second</code>
     * </p>
     * <p>
     * If you send a batch message to a topic, Amazon SNS publishes the batch message to each endpoint that is
     * subscribed to the topic. The format of the batch message depends on the notification protocol for each subscribed
     * endpoint.
     * </p>
     * <p>
     * When a <code>messageId</code> is returned, the batch message is saved, and Amazon SNS immediately delivers the
     * message to subscribers.
     * </p>
     *
     * @param publishBatchRequest
     * @return A Java Future containing the result of the PublishBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>BatchEntryIdsNotDistinctException Two or more batch entries in the request have the same
     *         <code>Id</code>.</li>
     *         <li>BatchRequestTooLongException The length of all the batch messages put together is more than the
     *         limit.</li>
     *         <li>EmptyBatchRequestException The batch request doesn't contain any entries.</li>
     *         <li>InvalidBatchEntryIdException The <code>Id</code> of a batch entry in a batch request doesn't abide by
     *         the specification.</li>
     *         <li>TooManyEntriesInBatchRequestException The batch request contains more entries than permissible (more
     *         than 10).</li>
     *         <li>KmsDisabledException The request was rejected because the specified Amazon Web Services KMS key isn't
     *         enabled.</li>
     *         <li>KmsInvalidStateException The request was rejected because the state of the specified resource isn't
     *         valid for this request. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web
     *         Services KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</li>
     *         <li>KmsNotFoundException The request was rejected because the specified entity or resource can't be
     *         found.</li>
     *         <li>KmsOptInRequiredException The Amazon Web Services access key ID needs a subscription for the service.
     *         </li>
     *         <li>KmsThrottlingException The request was denied due to request throttling. For more information about
     *         throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>Key Management Service Developer Guide.</i></li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that you don't have
     *         access to.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.PublishBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PublishBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishBatchResponse> publishBatch(PublishBatchRequest publishBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Publishes up to 10 messages to the specified topic in a single batch. This is a batch version of the
     * <code>Publish</code> API. If you try to send more than 10 messages in a single batch request, you will receive a
     * <code>TooManyEntriesInBatchRequest</code> exception.
     * </p>
     * <p>
     * For FIFO topics, multiple messages within a single batch are published in the order they are sent, and messages
     * are deduplicated within the batch and across batches for five minutes.
     * </p>
     * <p>
     * The result of publishing each message is reported individually in the response. Because the batch request can
     * result in a combination of successful and unsuccessful actions, you should check for batch errors even when the
     * call returns an HTTP status code of 200.
     * </p>
     * <p>
     * The maximum allowed individual message size and the maximum total payload size (the sum of the individual lengths
     * of all of the batched messages) are both 256 KB (262,144 bytes).
     * </p>
     * <important>
     * <p>
     * The <code>PublishBatch</code> API can send up to 10 messages at a time. If you attempt to send more than 10
     * messages in one request, you will encounter a <code>TooManyEntriesInBatchRequest</code> exception. In such cases,
     * split your messages into multiple requests, each containing no more than 10 messages.
     * </p>
     * </important>
     * <p>
     * Some actions take lists of parameters. These lists are specified using the <code>param.n</code> notation. Values
     * of <code>n</code> are integers starting from <b>1</b>. For example, a parameter list with two elements looks like
     * this:
     * </p>
     * <p>
     * <code>&amp;AttributeName.1=first</code>
     * </p>
     * <p>
     * <code>&amp;AttributeName.2=second</code>
     * </p>
     * <p>
     * If you send a batch message to a topic, Amazon SNS publishes the batch message to each endpoint that is
     * subscribed to the topic. The format of the batch message depends on the notification protocol for each subscribed
     * endpoint.
     * </p>
     * <p>
     * When a <code>messageId</code> is returned, the batch message is saved, and Amazon SNS immediately delivers the
     * message to subscribers.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PublishBatchRequest.Builder} avoiding the need to
     * create one manually via {@link PublishBatchRequest#builder()}
     * </p>
     *
     * @param publishBatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.PublishBatchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PublishBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InvalidParameterValueException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>EndpointDisabledException Exception error indicating endpoint disabled.</li>
     *         <li>PlatformApplicationDisabledException Exception error indicating platform application disabled.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>BatchEntryIdsNotDistinctException Two or more batch entries in the request have the same
     *         <code>Id</code>.</li>
     *         <li>BatchRequestTooLongException The length of all the batch messages put together is more than the
     *         limit.</li>
     *         <li>EmptyBatchRequestException The batch request doesn't contain any entries.</li>
     *         <li>InvalidBatchEntryIdException The <code>Id</code> of a batch entry in a batch request doesn't abide by
     *         the specification.</li>
     *         <li>TooManyEntriesInBatchRequestException The batch request contains more entries than permissible (more
     *         than 10).</li>
     *         <li>KmsDisabledException The request was rejected because the specified Amazon Web Services KMS key isn't
     *         enabled.</li>
     *         <li>KmsInvalidStateException The request was rejected because the state of the specified resource isn't
     *         valid for this request. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web
     *         Services KMS keys</a> in the <i>Key Management Service Developer Guide</i>.</li>
     *         <li>KmsNotFoundException The request was rejected because the specified entity or resource can't be
     *         found.</li>
     *         <li>KmsOptInRequiredException The Amazon Web Services access key ID needs a subscription for the service.
     *         </li>
     *         <li>KmsThrottlingException The request was denied due to request throttling. For more information about
     *         throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>Key Management Service Developer Guide.</i></li>
     *         <li>KmsAccessDeniedException The ciphertext references a key that doesn't exist or that you don't have
     *         access to.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>ValidationException Indicates that a parameter in the request is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.PublishBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PublishBatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PublishBatchResponse> publishBatch(Consumer<PublishBatchRequest.Builder> publishBatchRequest) {
        return publishBatch(PublishBatchRequest.builder().applyMutation(publishBatchRequest).build());
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.
     * </p>
     *
     * @param putDataProtectionPolicyRequest
     * @return A Java Future containing the result of the PutDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.PutDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PutDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDataProtectionPolicyResponse> putDataProtectionPolicy(
            PutDataProtectionPolicyRequest putDataProtectionPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is stored in the specified Amazon SNS topic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDataProtectionPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link PutDataProtectionPolicyRequest#builder()}
     * </p>
     *
     * @param putDataProtectionPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.PutDataProtectionPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutDataProtectionPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.PutDataProtectionPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/PutDataProtectionPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutDataProtectionPolicyResponse> putDataProtectionPolicy(
            Consumer<PutDataProtectionPolicyRequest.Builder> putDataProtectionPolicyRequest) {
        return putDataProtectionPolicy(PutDataProtectionPolicyRequest.builder().applyMutation(putDataProtectionPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Removes a statement from a topic's access control policy.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note>
     *
     * @param removePermissionRequest
     *        Input for RemovePermission action.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(RemovePermissionRequest removePermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a statement from a topic's access control policy.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemovePermissionRequest.Builder} avoiding the need
     * to create one manually via {@link RemovePermissionRequest#builder()}
     * </p>
     *
     * @param removePermissionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.RemovePermissionRequest.Builder} to create a request.
     *        Input for RemovePermission action.
     * @return A Java Future containing the result of the RemovePermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.RemovePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/RemovePermission" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemovePermissionResponse> removePermission(
            Consumer<RemovePermissionRequest.Builder> removePermissionRequest) {
        return removePermission(RemovePermissionRequest.builder().applyMutation(removePermissionRequest).build());
    }

    /**
     * <p>
     * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     *
     * @param setEndpointAttributesRequest
     *        Input for <code>SetEndpointAttributes</code> action.
     * @return A Java Future containing the result of the SetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetEndpointAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetEndpointAttributesResponse> setEndpointAttributes(
            SetEndpointAttributesRequest setEndpointAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the attributes for an endpoint for a device on one of the supported push notification services, such as GCM
     * (Firebase Cloud Messaging) and APNS. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetEndpointAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link SetEndpointAttributesRequest#builder()}
     * </p>
     *
     * @param setEndpointAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest.Builder} to create a
     *        request. Input for <code>SetEndpointAttributes</code> action.
     * @return A Java Future containing the result of the SetEndpointAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetEndpointAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetEndpointAttributes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SetEndpointAttributesResponse> setEndpointAttributes(
            Consumer<SetEndpointAttributesRequest.Builder> setEndpointAttributesRequest) {
        return setEndpointAttributes(SetEndpointAttributesRequest.builder().applyMutation(setEndpointAttributesRequest).build());
    }

    /**
     * <p>
     * Sets the attributes of the platform application object for the supported push notification services, such as APNS
     * and GCM (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>. For information on configuring attributes for message delivery status, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application Attributes for
     * Message Delivery Status</a>.
     * </p>
     *
     * @param setPlatformApplicationAttributesRequest
     *        Input for <code>SetPlatformApplicationAttributes</code> action.
     * @return A Java Future containing the result of the SetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetPlatformApplicationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPlatformApplicationAttributesResponse> setPlatformApplicationAttributes(
            SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the attributes of the platform application object for the supported push notification services, such as APNS
     * and GCM (Firebase Cloud Messaging). For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html">Using Amazon SNS Mobile Push
     * Notifications</a>. For information on configuring attributes for message delivery status, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html">Using Amazon SNS Application Attributes for
     * Message Delivery Status</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetPlatformApplicationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link SetPlatformApplicationAttributesRequest#builder()}
     * </p>
     *
     * @param setPlatformApplicationAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SetPlatformApplicationAttributesRequest.Builder} to
     *        create a request. Input for <code>SetPlatformApplicationAttributes</code> action.
     * @return A Java Future containing the result of the SetPlatformApplicationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetPlatformApplicationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetPlatformApplicationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SetPlatformApplicationAttributesResponse> setPlatformApplicationAttributes(
            Consumer<SetPlatformApplicationAttributesRequest.Builder> setPlatformApplicationAttributesRequest) {
        return setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest.builder()
                .applyMutation(setPlatformApplicationAttributesRequest).build());
    }

    /**
     * <p>
     * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
     * </p>
     * <p>
     * You can override some of these settings for a single message when you use the <code>Publish</code> action with
     * the <code>MessageAttributes.entry.N</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Publishing to a mobile phone</a> in
     * the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this operation, you must grant the Amazon SNS service principal (<code>sns.amazonaws.com</code>)
     * permission to perform the <code>s3:ListBucket</code> action.
     * </p>
     * </note>
     *
     * @param setSmsAttributesRequest
     *        The input for the SetSMSAttributes action.
     * @return A Java Future containing the result of the SetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetSMSAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSMSAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetSmsAttributesResponse> setSMSAttributes(SetSmsAttributesRequest setSmsAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this request to set the default settings for sending SMS messages and receiving daily SMS usage reports.
     * </p>
     * <p>
     * You can override some of these settings for a single message when you use the <code>Publish</code> action with
     * the <code>MessageAttributes.entry.N</code> parameter. For more information, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sms_publish-to-phone.html">Publishing to a mobile phone</a> in
     * the <i>Amazon SNS Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * To use this operation, you must grant the Amazon SNS service principal (<code>sns.amazonaws.com</code>)
     * permission to perform the <code>s3:ListBucket</code> action.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSmsAttributesRequest.Builder} avoiding the need
     * to create one manually via {@link SetSmsAttributesRequest#builder()}
     * </p>
     *
     * @param setSmsAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SetSmsAttributesRequest.Builder} to create a request. The
     *        input for the SetSMSAttributes action.
     * @return A Java Future containing the result of the SetSMSAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetSMSAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSMSAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSMSAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetSmsAttributesResponse> setSMSAttributes(
            Consumer<SetSmsAttributesRequest.Builder> setSmsAttributesRequest) {
        return setSMSAttributes(SetSmsAttributesRequest.builder().applyMutation(setSmsAttributesRequest).build());
    }

    /**
     * <p>
     * Allows a subscription owner to set an attribute of the subscription to a new value.
     * </p>
     *
     * @param setSubscriptionAttributesRequest
     *        Input for SetSubscriptionAttributes action.
     * @return A Java Future containing the result of the SetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetSubscriptionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSubscriptionAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetSubscriptionAttributesResponse> setSubscriptionAttributes(
            SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a subscription owner to set an attribute of the subscription to a new value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetSubscriptionAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link SetSubscriptionAttributesRequest#builder()}
     * </p>
     *
     * @param setSubscriptionAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SetSubscriptionAttributesRequest.Builder} to create a
     *        request. Input for SetSubscriptionAttributes action.
     * @return A Java Future containing the result of the SetSubscriptionAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetSubscriptionAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetSubscriptionAttributes" target="_top">AWS
     *      API Documentation</a>
     * @see <a
     *      href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetSubscriptionAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetSubscriptionAttributesResponse> setSubscriptionAttributes(
            Consumer<SetSubscriptionAttributesRequest.Builder> setSubscriptionAttributesRequest) {
        return setSubscriptionAttributes(SetSubscriptionAttributesRequest.builder()
                .applyMutation(setSubscriptionAttributesRequest).build());
    }

    /**
     * <p>
     * Allows a topic owner to set an attribute of the topic to a new value.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note>
     *
     * @param setTopicAttributesRequest
     *        Input for SetTopicAttributes action.
     * @return A Java Future containing the result of the SetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetTopicAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetTopicAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetTopicAttributesResponse> setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows a topic owner to set an attribute of the topic to a new value.
     * </p>
     * <note>
     * <p>
     * To remove the ability to change topic permissions, you must deny permissions to the <code>AddPermission</code>,
     * <code>RemovePermission</code>, and <code>SetTopicAttributes</code> actions in your IAM policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SetTopicAttributesRequest.Builder} avoiding the
     * need to create one manually via {@link SetTopicAttributesRequest#builder()}
     * </p>
     *
     * @param setTopicAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SetTopicAttributesRequest.Builder} to create a request.
     *        Input for SetTopicAttributes action.
     * @return A Java Future containing the result of the SetTopicAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.SetTopicAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/SetTopicAttributes" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_SetTopicAttributes_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SetTopicAttributesResponse> setTopicAttributes(
            Consumer<SetTopicAttributesRequest.Builder> setTopicAttributesRequest) {
        return setTopicAttributes(SetTopicAttributesRequest.builder().applyMutation(setTopicAttributesRequest).build());
    }

    /**
     * <p>
     * Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and
     * the topic are not in the same Amazon Web Services account, the endpoint owner must run the
     * <code>ConfirmSubscription</code> action to confirm the subscription.
     * </p>
     * <p>
     * You call the <code>ConfirmSubscription</code> action with the token from the subscription response. Confirmation
     * tokens are valid for two days.
     * </p>
     * <p>
     * This action is throttled at 100 transactions per second (TPS).
     * </p>
     *
     * @param subscribeRequest
     *        Input for Subscribe action.
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Subscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Subscribe_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(SubscribeRequest subscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Subscribes an endpoint to an Amazon SNS topic. If the endpoint type is HTTP/S or email, or if the endpoint and
     * the topic are not in the same Amazon Web Services account, the endpoint owner must run the
     * <code>ConfirmSubscription</code> action to confirm the subscription.
     * </p>
     * <p>
     * You call the <code>ConfirmSubscription</code> action with the token from the subscription response. Confirmation
     * tokens are valid for two days.
     * </p>
     * <p>
     * This action is throttled at 100 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link SubscribeRequest#builder()}
     * </p>
     *
     * @param subscribeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.SubscribeRequest.Builder} to create a request. Input for
     *        Subscribe action.
     * @return A Java Future containing the result of the Subscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>SubscriptionLimitExceededException Indicates that the customer already owns the maximum allowed
     *         number of subscriptions.</li>
     *         <li>FilterPolicyLimitExceededException Indicates that the number of filter polices in your Amazon Web
     *         Services account exceeds the limit. To add more filter polices, submit an Amazon SNS Limit Increase case
     *         in the Amazon Web ServicesSupport Center.</li>
     *         <li>ReplayLimitExceededException Indicates that the request parameter has exceeded the maximum number of
     *         concurrent message replays.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Subscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Subscribe" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Subscribe_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<SubscribeResponse> subscribe(Consumer<SubscribeRequest.Builder> subscribeRequest) {
        return subscribe(SubscribeRequest.builder().applyMutation(subscribeRequest).build());
    }

    /**
     * <p>
     * Add tags to the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer
     * Guide</i>.
     * </p>
     * <p>
     * When you use topic tags, keep the following guidelines in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Adding more than 50 tags to a topic isn't recommended.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags don't have any semantic meaning. Amazon SNS interprets tags as character strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * A new tag with a key identical to that of an existing tag overwrites the existing tag.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tagging actions are limited to 10 TPS per Amazon Web Services account, per Amazon Web Services Region. If your
     * application requires a higher throughput, file a <a
     * href="https://console.aws.amazon.com/support/home#/case/create?issueType=technical">technical support
     * request</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_TagResource_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add tags to the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer
     * Guide</i>.
     * </p>
     * <p>
     * When you use topic tags, keep the following guidelines in mind:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Adding more than 50 tags to a topic isn't recommended.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags don't have any semantic meaning. Amazon SNS interprets tags as character strings.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * A new tag with a key identical to that of an existing tag overwrites the existing tag.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tagging actions are limited to 10 TPS per Amazon Web Services account, per Amazon Web Services Region. If your
     * application requires a higher throughput, file a <a
     * href="https://console.aws.amazon.com/support/home#/case/create?issueType=technical">technical support
     * request</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_TagResource_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the
     * subscription or the topic's owner can unsubscribe, and an Amazon Web Services signature is required. If the
     * <code>Unsubscribe</code> call does not require authentication and the requester is not the subscription owner, a
     * final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the
     * topic if the <code>Unsubscribe</code> request was unintended.
     * </p>
     * <p>
     * This action is throttled at 100 transactions per second (TPS).
     * </p>
     *
     * @param unsubscribeRequest
     *        Input for Unsubscribe action.
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Unsubscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Unsubscribe_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(UnsubscribeRequest unsubscribeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a subscription. If the subscription requires authentication for deletion, only the owner of the
     * subscription or the topic's owner can unsubscribe, and an Amazon Web Services signature is required. If the
     * <code>Unsubscribe</code> call does not require authentication and the requester is not the subscription owner, a
     * final cancellation message is delivered to the endpoint, so that the endpoint owner can easily resubscribe to the
     * topic if the <code>Unsubscribe</code> request was unintended.
     * </p>
     * <p>
     * This action is throttled at 100 transactions per second (TPS).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnsubscribeRequest.Builder} avoiding the need to
     * create one manually via {@link UnsubscribeRequest#builder()}
     * </p>
     *
     * @param unsubscribeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.UnsubscribeRequest.Builder} to create a request. Input
     *        for Unsubscribe action.
     * @return A Java Future containing the result of the Unsubscribe operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>NotFoundException Indicates that the requested resource does not exist.</li>
     *         <li>InvalidSecurityException The credential signature isn't valid. You must use an HTTPS endpoint and
     *         sign your request using Signature Version 4.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.Unsubscribe
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/Unsubscribe" target="_top">AWS API
     *      Documentation</a>
     * @see <a href="https://docs.aws.amazon.com/code-library/latest/ug/sns_example_sns_Unsubscribe_section.html"
     *      target="_top">Code Example</a>
     */
    default CompletableFuture<UnsubscribeResponse> unsubscribe(Consumer<UnsubscribeRequest.Builder> unsubscribeRequest) {
        return unsubscribe(UnsubscribeRequest.builder().applyMutation(unsubscribeRequest).build());
    }

    /**
     * <p>
     * Remove tags from the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer
     * Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove tags from the specified Amazon SNS topic. For an overview, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-tags.html">Amazon SNS Tags</a> in the <i>Amazon SNS Developer
     * Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>TagLimitExceededException Can't add more than 50 tags to a topic.</li>
     *         <li>StaleTagException A tag has been added to a resource with the same ARN as a deleted resource. Wait a
     *         short while and then retry the operation.</li>
     *         <li>TagPolicyException The request doesn't comply with the IAM tag policy. Correct your request and then
     *         retry it.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>ConcurrentAccessException Can't perform multiple operations on a tag simultaneously. Perform the
     *         operations sequentially.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     *
     * @param verifySmsSandboxPhoneNumberRequest
     * @return A Java Future containing the result of the VerifySMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>VerificationException Indicates that the one-time password (OTP) used for verification is invalid.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.VerifySMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/VerifySMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySmsSandboxPhoneNumberResponse> verifySMSSandboxPhoneNumber(
            VerifySmsSandboxPhoneNumberRequest verifySmsSandboxPhoneNumberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Verifies a destination phone number with a one-time password (OTP) for the calling Amazon Web Services account.
     * </p>
     * <p>
     * When you start using Amazon SNS to send SMS messages, your Amazon Web Services account is in the <i>SMS
     * sandbox</i>. The SMS sandbox provides a safe environment for you to try Amazon SNS features without risking your
     * reputation as an SMS sender. While your Amazon Web Services account is in the SMS sandbox, you can use all of the
     * features of Amazon SNS. However, you can send SMS messages only to verified destination phone numbers. For more
     * information, including how to move out of the sandbox to send messages without restrictions, see <a
     * href="https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox.html">SMS sandbox</a> in the <i>Amazon SNS
     * Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VerifySmsSandboxPhoneNumberRequest.Builder}
     * avoiding the need to create one manually via {@link VerifySmsSandboxPhoneNumberRequest#builder()}
     * </p>
     *
     * @param verifySmsSandboxPhoneNumberRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.sns.model.VerifySmsSandboxPhoneNumberRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the VerifySMSSandboxPhoneNumber operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AuthorizationErrorException Indicates that the user has been denied access to the requested resource.
     *         </li>
     *         <li>InternalErrorException Indicates an internal service error.</li>
     *         <li>InvalidParameterException Indicates that a request parameter does not comply with the associated
     *         constraints.</li>
     *         <li>ResourceNotFoundException Can’t perform the action on the specified resource. Make sure that the
     *         resource exists.</li>
     *         <li>VerificationException Indicates that the one-time password (OTP) used for verification is invalid.</li>
     *         <li>ThrottledException Indicates that the rate at which requests have been submitted for this action
     *         exceeds the limit for your Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SnsException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SnsAsyncClient.VerifySMSSandboxPhoneNumber
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/VerifySMSSandboxPhoneNumber"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VerifySmsSandboxPhoneNumberResponse> verifySMSSandboxPhoneNumber(
            Consumer<VerifySmsSandboxPhoneNumberRequest.Builder> verifySmsSandboxPhoneNumberRequest) {
        return verifySMSSandboxPhoneNumber(VerifySmsSandboxPhoneNumberRequest.builder()
                .applyMutation(verifySmsSandboxPhoneNumberRequest).build());
    }

    @Override
    default SnsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SnsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SnsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SnsAsyncClient}.
     */
    static SnsAsyncClientBuilder builder() {
        return new DefaultSnsAsyncClientBuilder();
    }
}
