/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataProtectionPolicyRequest extends SnsRequest implements
        ToCopyableBuilder<PutDataProtectionPolicyRequest.Builder, PutDataProtectionPolicyRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(PutDataProtectionPolicyRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> DATA_PROTECTION_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataProtectionPolicy").getter(getter(PutDataProtectionPolicyRequest::dataProtectionPolicy))
            .setter(setter(Builder::dataProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProtectionPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            DATA_PROTECTION_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String dataProtectionPolicy;

    private PutDataProtectionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.dataProtectionPolicy = builder.dataProtectionPolicy;
    }

    /**
     * <p>
     * The ARN of the topic whose <code>DataProtectionPolicy</code> you want to add or update.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the Amazon Web Services General Reference.
     * </p>
     * 
     * @return The ARN of the topic whose <code>DataProtectionPolicy</code> you want to add or update.</p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the Amazon Web Services General Reference.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The JSON serialization of the topic's <code>DataProtectionPolicy</code>.
     * </p>
     * <p>
     * The <code>DataProtectionPolicy</code> must be in JSON string format.
     * </p>
     * <p>
     * Length Constraints: Maximum length of 30,720.
     * </p>
     * 
     * @return The JSON serialization of the topic's <code>DataProtectionPolicy</code>.</p>
     *         <p>
     *         The <code>DataProtectionPolicy</code> must be in JSON string format.
     *         </p>
     *         <p>
     *         Length Constraints: Maximum length of 30,720.
     */
    public final String dataProtectionPolicy() {
        return dataProtectionPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataProtectionPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataProtectionPolicyRequest)) {
            return false;
        }
        PutDataProtectionPolicyRequest other = (PutDataProtectionPolicyRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(dataProtectionPolicy(), other.dataProtectionPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataProtectionPolicyRequest").add("ResourceArn", resourceArn())
                .add("DataProtectionPolicy", dataProtectionPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "DataProtectionPolicy":
            return Optional.ofNullable(clazz.cast(dataProtectionPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("DataProtectionPolicy", DATA_PROTECTION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataProtectionPolicyRequest, T> g) {
        return obj -> g.apply((PutDataProtectionPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutDataProtectionPolicyRequest> {
        /**
         * <p>
         * The ARN of the topic whose <code>DataProtectionPolicy</code> you want to add or update.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the Amazon Web Services General Reference.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the topic whose <code>DataProtectionPolicy</code> you want to add or update.</p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the Amazon Web Services General Reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The JSON serialization of the topic's <code>DataProtectionPolicy</code>.
         * </p>
         * <p>
         * The <code>DataProtectionPolicy</code> must be in JSON string format.
         * </p>
         * <p>
         * Length Constraints: Maximum length of 30,720.
         * </p>
         * 
         * @param dataProtectionPolicy
         *        The JSON serialization of the topic's <code>DataProtectionPolicy</code>.</p>
         *        <p>
         *        The <code>DataProtectionPolicy</code> must be in JSON string format.
         *        </p>
         *        <p>
         *        Length Constraints: Maximum length of 30,720.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataProtectionPolicy(String dataProtectionPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SnsRequest.BuilderImpl implements Builder {
        private String resourceArn;

        private String dataProtectionPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataProtectionPolicyRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            dataProtectionPolicy(model.dataProtectionPolicy);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getDataProtectionPolicy() {
            return dataProtectionPolicy;
        }

        public final void setDataProtectionPolicy(String dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
        }

        @Override
        public final Builder dataProtectionPolicy(String dataProtectionPolicy) {
            this.dataProtectionPolicy = dataProtectionPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataProtectionPolicyRequest build() {
            return new PutDataProtectionPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
