/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishBatchResponse extends SnsResponse implements
        ToCopyableBuilder<PublishBatchResponse.Builder, PublishBatchResponse> {
    private static final SdkField<List<PublishBatchResultEntry>> SUCCESSFUL_FIELD = SdkField
            .<List<PublishBatchResultEntry>> builder(MarshallingType.LIST)
            .memberName("Successful")
            .getter(getter(PublishBatchResponse::successful))
            .setter(setter(Builder::successful))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PublishBatchResultEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublishBatchResultEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchResultErrorEntry>> FAILED_FIELD = SdkField
            .<List<BatchResultErrorEntry>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(PublishBatchResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchResultErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchResultErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SUCCESSFUL_FIELD, FAILED_FIELD));

    private final List<PublishBatchResultEntry> successful;

    private final List<BatchResultErrorEntry> failed;

    private PublishBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successful property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccessful() {
        return successful != null && !(successful instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of successful <code>PublishBatch</code> responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccessful} method.
     * </p>
     * 
     * @return A list of successful <code>PublishBatch</code> responses.
     */
    public final List<PublishBatchResultEntry> successful() {
        return successful;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of failed <code>PublishBatch</code> responses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return A list of failed <code>PublishBatch</code> responses.
     */
    public final List<BatchResultErrorEntry> failed() {
        return failed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccessful() ? successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishBatchResponse)) {
            return false;
        }
        PublishBatchResponse other = (PublishBatchResponse) obj;
        return hasSuccessful() == other.hasSuccessful() && Objects.equals(successful(), other.successful())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishBatchResponse").add("Successful", hasSuccessful() ? successful() : null)
                .add("Failed", hasFailed() ? failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Successful":
            return Optional.ofNullable(clazz.cast(successful()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublishBatchResponse, T> g) {
        return obj -> g.apply((PublishBatchResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SnsResponse.Builder, SdkPojo, CopyableBuilder<Builder, PublishBatchResponse> {
        /**
         * <p>
         * A list of successful <code>PublishBatch</code> responses.
         * </p>
         * 
         * @param successful
         *        A list of successful <code>PublishBatch</code> responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<PublishBatchResultEntry> successful);

        /**
         * <p>
         * A list of successful <code>PublishBatch</code> responses.
         * </p>
         * 
         * @param successful
         *        A list of successful <code>PublishBatch</code> responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(PublishBatchResultEntry... successful);

        /**
         * <p>
         * A list of successful <code>PublishBatch</code> responses.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PublishBatchResultEntry>.Builder}
         * avoiding the need to create one manually via {@link List<PublishBatchResultEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PublishBatchResultEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #successful(List<PublishBatchResultEntry>)}.
         * 
         * @param successful
         *        a consumer that will call methods on {@link List<PublishBatchResultEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successful(List<PublishBatchResultEntry>)
         */
        Builder successful(Consumer<PublishBatchResultEntry.Builder>... successful);

        /**
         * <p>
         * A list of failed <code>PublishBatch</code> responses.
         * </p>
         * 
         * @param failed
         *        A list of failed <code>PublishBatch</code> responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<BatchResultErrorEntry> failed);

        /**
         * <p>
         * A list of failed <code>PublishBatch</code> responses.
         * </p>
         * 
         * @param failed
         *        A list of failed <code>PublishBatch</code> responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(BatchResultErrorEntry... failed);

        /**
         * <p>
         * A list of failed <code>PublishBatch</code> responses.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchResultErrorEntry>.Builder}
         * avoiding the need to create one manually via {@link List<BatchResultErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchResultErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link #failed(List<BatchResultErrorEntry>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<BatchResultErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<BatchResultErrorEntry>)
         */
        Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed);
    }

    static final class BuilderImpl extends SnsResponse.BuilderImpl implements Builder {
        private List<PublishBatchResultEntry> successful = DefaultSdkAutoConstructList.getInstance();

        private List<BatchResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PublishBatchResponse model) {
            super(model);
            successful(model.successful);
            failed(model.failed);
        }

        public final List<PublishBatchResultEntry.Builder> getSuccessful() {
            List<PublishBatchResultEntry.Builder> result = PublishBatchResultEntryListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<PublishBatchResultEntry.BuilderImpl> successful) {
            this.successful = PublishBatchResultEntryListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<PublishBatchResultEntry> successful) {
            this.successful = PublishBatchResultEntryListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(PublishBatchResultEntry... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<PublishBatchResultEntry.Builder>... successful) {
            successful(Stream.of(successful).map(c -> PublishBatchResultEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchResultErrorEntry.Builder> getFailed() {
            List<BatchResultErrorEntry.Builder> result = BatchResultErrorEntryListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchResultErrorEntry.BuilderImpl> failed) {
            this.failed = BatchResultErrorEntryListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchResultErrorEntry> failed) {
            this.failed = BatchResultErrorEntryListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchResultErrorEntry... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchResultErrorEntry.Builder>... failed) {
            failed(Stream.of(failed).map(c -> BatchResultErrorEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PublishBatchResponse build() {
            return new PublishBatchResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
