/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.AddPermissionRequest;

public class AddPermissionRequestMarshaller
implements Marshaller<Request<AddPermissionRequest>, AddPermissionRequest> {
    public Request<AddPermissionRequest> marshall(AddPermissionRequest addPermissionRequest) {
        List<String> actionNamesList;
        List<String> aWSAccountIdsList;
        if (addPermissionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)addPermissionRequest, "SNSClient");
        request.addParameter("Action", "AddPermission");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addPermissionRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)addPermissionRequest.topicArn()));
        }
        if (addPermissionRequest.label() != null) {
            request.addParameter("Label", StringUtils.fromString((String)addPermissionRequest.label()));
        }
        if ((aWSAccountIdsList = addPermissionRequest.awsAccountIds()) != null) {
            if (!aWSAccountIdsList.isEmpty()) {
                int aWSAccountIdsListIndex = 1;
                for (String aWSAccountIdsListValue : aWSAccountIdsList) {
                    if (aWSAccountIdsListValue != null) {
                        request.addParameter("AWSAccountId.member." + aWSAccountIdsListIndex, StringUtils.fromString((String)aWSAccountIdsListValue));
                    }
                    ++aWSAccountIdsListIndex;
                }
            } else {
                request.addParameter("AWSAccountId", "");
            }
        }
        if ((actionNamesList = addPermissionRequest.actionNames()) != null) {
            if (!actionNamesList.isEmpty()) {
                int actionNamesListIndex = 1;
                for (String actionNamesListValue : actionNamesList) {
                    if (actionNamesListValue != null) {
                        request.addParameter("ActionName.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                    }
                    ++actionNamesListIndex;
                }
            } else {
                request.addParameter("ActionName", "");
            }
        }
        return request;
    }
}

