/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.sns.model.PhoneNumberListCopier;
import software.amazon.awssdk.services.sns.model.SNSResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPhoneNumbersOptedOutResponse
extends SNSResponse
implements ToCopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
    private final List<String> phoneNumbers;
    private final String nextToken;

    private ListPhoneNumbersOptedOutResponse(BuilderImpl builder) {
        super(builder);
        this.phoneNumbers = builder.phoneNumbers;
        this.nextToken = builder.nextToken;
    }

    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumbers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersOptedOutResponse)) {
            return false;
        }
        ListPhoneNumbersOptedOutResponse other = (ListPhoneNumbersOptedOutResponse)((Object)obj);
        return Objects.equals(this.phoneNumbers(), other.phoneNumbers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListPhoneNumbersOptedOutResponse").add("PhoneNumbers", this.phoneNumbers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "phoneNumbers": {
                return Optional.of(clazz.cast(this.phoneNumbers()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSResponse.BuilderImpl
    implements Builder {
        private List<String> phoneNumbers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersOptedOutResponse model) {
            this.phoneNumbers(model.phoneNumbers);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        @Override
        public final Builder phoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumbers(String ... phoneNumbers) {
            this.phoneNumbers(Arrays.asList(phoneNumbers));
            return this;
        }

        public final void setPhoneNumbers(Collection<String> phoneNumbers) {
            this.phoneNumbers = PhoneNumberListCopier.copy(phoneNumbers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPhoneNumbersOptedOutResponse build() {
            return new ListPhoneNumbersOptedOutResponse(this);
        }
    }

    public static interface Builder
    extends SNSResponse.Builder,
    CopyableBuilder<Builder, ListPhoneNumbersOptedOutResponse> {
        public Builder phoneNumbers(Collection<String> var1);

        public Builder phoneNumbers(String ... var1);

        public Builder nextToken(String var1);
    }
}

