/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsResponse;
import software.amazon.awssdk.services.sns.model.Subscription;

public final class ListSubscriptionsPaginator
implements SdkIterable<ListSubscriptionsResponse> {
    private final SNSClient client;
    private final ListSubscriptionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListSubscriptionsPaginator(SNSClient client, ListSubscriptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSubscriptionsResponseFetcher();
    }

    public Iterator<ListSubscriptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Subscription> subscriptions() {
        Function<ListSubscriptionsResponse, Iterator> getIterator = response -> response != null ? response.subscriptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListSubscriptionsResponseFetcher
    implements NextPageFetcher<ListSubscriptionsResponse> {
        private ListSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListSubscriptionsResponse nextPage(ListSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionsPaginator.this.client.listSubscriptions(ListSubscriptionsPaginator.this.firstRequest);
            }
            return ListSubscriptionsPaginator.this.client.listSubscriptions((ListSubscriptionsRequest)((Object)ListSubscriptionsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

