/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetSubscriptionAttributesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
    private final String subscriptionArn;
    private final String attributeName;
    private final String attributeValue;

    private SetSubscriptionAttributesRequest(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.attributeName = builder.attributeName;
        this.attributeValue = builder.attributeValue;
    }

    public String subscriptionArn() {
        return this.subscriptionArn;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetSubscriptionAttributesRequest)) {
            return false;
        }
        SetSubscriptionAttributesRequest other = (SetSubscriptionAttributesRequest)((Object)obj);
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.attributeValue(), other.attributeValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.subscriptionArn() != null) {
            sb.append("SubscriptionArn: ").append(this.subscriptionArn()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValue() != null) {
            sb.append("AttributeValue: ").append(this.attributeValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.of(clazz.cast(this.subscriptionArn()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "AttributeValue": {
                return Optional.of(clazz.cast(this.attributeValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String attributeName;
        private String attributeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SetSubscriptionAttributesRequest model) {
            this.subscriptionArn(model.subscriptionArn);
            this.attributeName(model.attributeName);
            this.attributeValue(model.attributeValue);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final String getAttributeValue() {
            return this.attributeValue;
        }

        @Override
        public final Builder attributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
            return this;
        }

        public final void setAttributeValue(String attributeValue) {
            this.attributeValue = attributeValue;
        }

        public SetSubscriptionAttributesRequest build() {
            return new SetSubscriptionAttributesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetSubscriptionAttributesRequest> {
        public Builder subscriptionArn(String var1);

        public Builder attributeName(String var1);

        public Builder attributeValue(String var1);
    }
}

