/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.util.StringUtils;

public class UnsubscribeRequestMarshaller
implements Marshaller<Request<UnsubscribeRequest>, UnsubscribeRequest> {
    public Request<UnsubscribeRequest> marshall(UnsubscribeRequest unsubscribeRequest) {
        if (unsubscribeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)unsubscribeRequest, "SNSClient");
        request.addParameter("Action", "Unsubscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (unsubscribeRequest.subscriptionArn() != null) {
            request.addParameter("SubscriptionArn", StringUtils.fromString((String)unsubscribeRequest.subscriptionArn()));
        }
        return request;
    }
}

