/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.SetSMSAttributesRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetSMSAttributesRequestMarshaller
implements Marshaller<Request<SetSMSAttributesRequest>, SetSMSAttributesRequest> {
    public Request<SetSMSAttributesRequest> marshall(SetSMSAttributesRequest setSMSAttributesRequest) {
        if (setSMSAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSMSAttributesRequest, "SNSClient");
        request.addParameter("Action", "SetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        Map<String, String> attributes = setSMSAttributesRequest.attributes();
        if (attributes != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("attributes.entry." + attributesListIndex + ".key", StringUtils.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("attributes.entry." + attributesListIndex + ".value", StringUtils.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

