/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateTopicRequestMarshaller
implements Marshaller<Request<CreateTopicRequest>, CreateTopicRequest> {
    public Request<CreateTopicRequest> marshall(CreateTopicRequest createTopicRequest) {
        if (createTopicRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTopicRequest, "SNSClient");
        request.addParameter("Action", "CreateTopic");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTopicRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createTopicRequest.name()));
        }
        return request;
    }
}

