/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.sns.model.SubscribeRequest;
import software.amazon.awssdk.util.StringUtils;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        if (subscribeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeRequest, "SNSClient");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (subscribeRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringUtils.fromString((String)subscribeRequest.topicArn()));
        }
        if (subscribeRequest.protocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)subscribeRequest.protocol()));
        }
        if (subscribeRequest.endpoint() != null) {
            request.addParameter("Endpoint", StringUtils.fromString((String)subscribeRequest.endpoint()));
        }
        return request;
    }
}

