/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.SetEndpointAttributesRequest;

public class SetEndpointAttributesRequestMarshaller
implements Marshaller<Request<SetEndpointAttributesRequest>, SetEndpointAttributesRequest> {
    public Request<SetEndpointAttributesRequest> marshall(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        Map<String, String> attributes;
        if (setEndpointAttributesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setEndpointAttributesRequest, "SnsClient");
        request.addParameter("Action", "SetEndpointAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (setEndpointAttributesRequest.endpointArn() != null) {
            request.addParameter("EndpointArn", StringConversion.fromString((String)setEndpointAttributesRequest.endpointArn()));
        }
        if ((attributes = setEndpointAttributesRequest.attributes()) != null) {
            int attributesListIndex = 1;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".key", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    request.addParameter("Attributes.entry." + attributesListIndex + ".value", StringConversion.fromString((String)entry.getValue()));
                }
                ++attributesListIndex;
            }
        }
        return request;
    }
}

