/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.Map;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.sns.model.MessageAttributeValue;
import software.amazon.awssdk.services.sns.model.PublishRequest;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        Map<String, MessageAttributeValue> messageAttributes;
        if (publishRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)publishRequest, "SnsClient");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (publishRequest.topicArn() != null) {
            request.addParameter("TopicArn", StringConversion.fromString((String)publishRequest.topicArn()));
        }
        if (publishRequest.targetArn() != null) {
            request.addParameter("TargetArn", StringConversion.fromString((String)publishRequest.targetArn()));
        }
        if (publishRequest.phoneNumber() != null) {
            request.addParameter("PhoneNumber", StringConversion.fromString((String)publishRequest.phoneNumber()));
        }
        if (publishRequest.message() != null) {
            request.addParameter("Message", StringConversion.fromString((String)publishRequest.message()));
        }
        if (publishRequest.subject() != null) {
            request.addParameter("Subject", StringConversion.fromString((String)publishRequest.subject()));
        }
        if (publishRequest.messageStructure() != null) {
            request.addParameter("MessageStructure", StringConversion.fromString((String)publishRequest.messageStructure()));
        }
        if ((messageAttributes = publishRequest.messageAttributes()) != null) {
            int messageAttributesListIndex = 1;
            for (Map.Entry<String, MessageAttributeValue> entry : messageAttributes.entrySet()) {
                if (entry.getKey() != null) {
                    request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Name", StringConversion.fromString((String)entry.getKey()));
                }
                if (entry.getValue() != null) {
                    if (entry.getValue().dataType() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.DataType", StringConversion.fromString((String)entry.getValue().dataType()));
                    }
                    if (entry.getValue().stringValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.StringValue", StringConversion.fromString((String)entry.getValue().stringValue()));
                    }
                    if (entry.getValue().binaryValue() != null) {
                        request.addParameter("MessageAttributes.entry." + messageAttributesListIndex + ".Value.BinaryValue", StringConversion.fromSdkBytes((SdkBytes)entry.getValue().binaryValue()));
                    }
                }
                ++messageAttributesListIndex;
            }
        }
        return request;
    }
}

