/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sns.SnsAsyncClient;
import software.amazon.awssdk.services.sns.model.Endpoint;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import software.amazon.awssdk.services.sns.model.ListEndpointsByPlatformApplicationResponse;

public class ListEndpointsByPlatformApplicationPublisher
implements SdkPublisher<ListEndpointsByPlatformApplicationResponse> {
    private final SnsAsyncClient client;
    private final ListEndpointsByPlatformApplicationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEndpointsByPlatformApplicationPublisher(SnsAsyncClient client, ListEndpointsByPlatformApplicationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEndpointsByPlatformApplicationPublisher(SnsAsyncClient client, ListEndpointsByPlatformApplicationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEndpointsByPlatformApplicationResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEndpointsByPlatformApplicationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Endpoint> endpoints() {
        Function<ListEndpointsByPlatformApplicationResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEndpointsByPlatformApplicationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final ListEndpointsByPlatformApplicationPublisher resume(ListEndpointsByPlatformApplicationResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListEndpointsByPlatformApplicationPublisher(this.client, (ListEndpointsByPlatformApplicationRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListEndpointsByPlatformApplicationPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListEndpointsByPlatformApplicationResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListEndpointsByPlatformApplicationResponseFetcher
    implements AsyncPageFetcher<ListEndpointsByPlatformApplicationResponse> {
        private ListEndpointsByPlatformApplicationResponseFetcher() {
        }

        public boolean hasNextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<ListEndpointsByPlatformApplicationResponse> nextPage(ListEndpointsByPlatformApplicationResponse previousPage) {
            if (previousPage == null) {
                return ListEndpointsByPlatformApplicationPublisher.this.client.listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationPublisher.this.firstRequest);
            }
            return ListEndpointsByPlatformApplicationPublisher.this.client.listEndpointsByPlatformApplication((ListEndpointsByPlatformApplicationRequest)((Object)ListEndpointsByPlatformApplicationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

