/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements ToCopyableBuilder<Builder, Subscription> {
    private final String subscriptionArn;
    private final String owner;
    private final String protocol;
    private final String endpoint;
    private final String topicArn;

    private Subscription(BuilderImpl builder) {
        this.subscriptionArn = builder.subscriptionArn;
        this.owner = builder.owner;
        this.protocol = builder.protocol;
        this.endpoint = builder.endpoint;
        this.topicArn = builder.topicArn;
    }

    public String subscriptionArn() {
        return this.subscriptionArn;
    }

    public String owner() {
        return this.owner;
    }

    public String protocol() {
        return this.protocol;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String topicArn() {
        return this.topicArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.topicArn(), other.topicArn());
    }

    public String toString() {
        return ToString.builder((String)"Subscription").add("SubscriptionArn", (Object)this.subscriptionArn()).add("Owner", (Object)this.owner()).add("Protocol", (Object)this.protocol()).add("Endpoint", (Object)this.endpoint()).add("TopicArn", (Object)this.topicArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private String owner;
        private String protocol;
        private String endpoint;
        private String topicArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionArn(model.subscriptionArn);
            this.owner(model.owner);
            this.protocol(model.protocol);
            this.endpoint(model.endpoint);
            this.topicArn(model.topicArn);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public Subscription build() {
            return new Subscription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionArn(String var1);

        public Builder owner(String var1);

        public Builder protocol(String var1);

        public Builder endpoint(String var1);

        public Builder topicArn(String var1);
    }
}

