/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.sns.model.GetSMSAttributesRequest;

public class GetSMSAttributesRequestMarshaller
implements Marshaller<Request<GetSMSAttributesRequest>, GetSMSAttributesRequest> {
    public Request<GetSMSAttributesRequest> marshall(GetSMSAttributesRequest getSMSAttributesRequest) {
        if (getSMSAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)getSMSAttributesRequest, "SNSClient");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> attributesList = getSMSAttributesRequest.attributes();
        if (attributesList != null) {
            if (!attributesList.isEmpty()) {
                int attributesListIndex = 1;
                for (String attributesListValue : attributesList) {
                    if (attributesListValue != null) {
                        request.addParameter("attributes.member." + attributesListIndex, StringUtils.fromString((String)attributesListValue));
                    }
                    ++attributesListIndex;
                }
            } else {
                request.addParameter("attributes", "");
            }
        }
        return request;
    }
}

