/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.sns.SNSClient;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsRequest;
import software.amazon.awssdk.services.sns.model.ListPlatformApplicationsResponse;
import software.amazon.awssdk.services.sns.model.PlatformApplication;

public class ListPlatformApplicationsIterable
implements SdkIterable<ListPlatformApplicationsResponse> {
    private final SNSClient client;
    private final ListPlatformApplicationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlatformApplicationsIterable(SNSClient client, ListPlatformApplicationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPlatformApplicationsResponseFetcher();
    }

    public Iterator<ListPlatformApplicationsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<PlatformApplication> platformApplications() {
        Function<ListPlatformApplicationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.platformApplications() != null) {
                return response.platformApplications().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListPlatformApplicationsIterable resume(ListPlatformApplicationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPlatformApplicationsIterable(this.client, (ListPlatformApplicationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPlatformApplicationsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPlatformApplicationsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPlatformApplicationsResponseFetcher
    implements SyncPageFetcher<ListPlatformApplicationsResponse> {
        private ListPlatformApplicationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlatformApplicationsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPlatformApplicationsResponse nextPage(ListPlatformApplicationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlatformApplicationsIterable.this.client.listPlatformApplications(ListPlatformApplicationsIterable.this.firstRequest);
            }
            return ListPlatformApplicationsIterable.this.client.listPlatformApplications((ListPlatformApplicationsRequest)((Object)ListPlatformApplicationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

