/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.sns.model.SNSResponse;
import software.amazon.awssdk.services.sns.model.Topic;
import software.amazon.awssdk.services.sns.model.TopicsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTopicsResponse
extends SNSResponse
implements ToCopyableBuilder<Builder, ListTopicsResponse> {
    private final List<Topic> topics;
    private final String nextToken;

    private ListTopicsResponse(BuilderImpl builder) {
        super(builder);
        this.topics = builder.topics;
        this.nextToken = builder.nextToken;
    }

    public List<Topic> topics() {
        return this.topics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topics());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicsResponse)) {
            return false;
        }
        ListTopicsResponse other = (ListTopicsResponse)((Object)obj);
        return Objects.equals(this.topics(), other.topics()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTopicsResponse").add("Topics", this.topics()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Topics": {
                return Optional.of(clazz.cast(this.topics()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends SNSResponse.BuilderImpl
    implements Builder {
        private List<Topic> topics;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicsResponse model) {
            super(model);
            this.topics(model.topics);
            this.nextToken(model.nextToken);
        }

        public final Collection<Topic.Builder> getTopics() {
            return this.topics != null ? (Collection)this.topics.stream().map(Topic::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topics(Collection<Topic> topics) {
            this.topics = TopicsListCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Topic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<Topic.Builder> ... topics) {
            this.topics(Stream.of(topics).map(c -> (Topic)((Topic.Builder)Topic.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTopics(Collection<Topic.BuilderImpl> topics) {
            this.topics = TopicsListCopier.copyFromBuilder(topics);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTopicsResponse build() {
            return new ListTopicsResponse(this);
        }
    }

    public static interface Builder
    extends SNSResponse.Builder,
    CopyableBuilder<Builder, ListTopicsResponse> {
        public Builder topics(Collection<Topic> var1);

        public Builder topics(Topic ... var1);

        public Builder topics(Consumer<Topic.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

