/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaResource implements SdkPojo, Serializable, ToCopyableBuilder<LambdaResource.Builder, LambdaResource> {
    private static final SdkField<String> LAMBDA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LambdaArn").getter(getter(LambdaResource::lambdaArn)).setter(setter(Builder::lambdaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaArn").build()).build();

    private static final SdkField<List<EventTriggerDefinition>> EVENT_TRIGGERS_FIELD = SdkField
            .<List<EventTriggerDefinition>> builder(MarshallingType.LIST)
            .memberName("EventTriggers")
            .getter(getter(LambdaResource::eventTriggers))
            .setter(setter(Builder::eventTriggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTriggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EventTriggerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(EventTriggerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_ARN_FIELD,
            EVENT_TRIGGERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String lambdaArn;

    private final List<EventTriggerDefinition> eventTriggers;

    private LambdaResource(BuilderImpl builder) {
        this.lambdaArn = builder.lambdaArn;
        this.eventTriggers = builder.eventTriggers;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the
     * associated local Amazon S3 resource.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on
     *         the associated local Amazon S3 resource.
     */
    public final String lambdaArn() {
        return lambdaArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventTriggers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventTriggers() {
        return eventTriggers != null && !(eventTriggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with this
     * job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventTriggers} method.
     * </p>
     * 
     * @return The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated
     *         with this job.
     */
    public final List<EventTriggerDefinition> eventTriggers() {
        return eventTriggers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventTriggers() ? eventTriggers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaResource)) {
            return false;
        }
        LambdaResource other = (LambdaResource) obj;
        return Objects.equals(lambdaArn(), other.lambdaArn()) && hasEventTriggers() == other.hasEventTriggers()
                && Objects.equals(eventTriggers(), other.eventTriggers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LambdaResource").add("LambdaArn", lambdaArn())
                .add("EventTriggers", hasEventTriggers() ? eventTriggers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LambdaArn":
            return Optional.ofNullable(clazz.cast(lambdaArn()));
        case "EventTriggers":
            return Optional.ofNullable(clazz.cast(eventTriggers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LambdaArn", LAMBDA_ARN_FIELD);
        map.put("EventTriggers", EVENT_TRIGGERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LambdaResource, T> g) {
        return obj -> g.apply((LambdaResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions on the
         * associated local Amazon S3 resource.
         * </p>
         * 
         * @param lambdaArn
         *        An Amazon Resource Name (ARN) that represents an Lambda function to be triggered by PUT object actions
         *        on the associated local Amazon S3 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaArn(String lambdaArn);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * 
         * @param eventTriggers
         *        The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects
         *        associated with this job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTriggers(EventTriggerDefinition... eventTriggers);

        /**
         * <p>
         * The array of ARNs for <a>S3Resource</a> objects to trigger the <a>LambdaResource</a> objects associated with
         * this job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.snowball.model.EventTriggerDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.snowball.model.EventTriggerDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.snowball.model.EventTriggerDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #eventTriggers(List<EventTriggerDefinition>)}.
         * 
         * @param eventTriggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.snowball.model.EventTriggerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventTriggers(java.util.Collection<EventTriggerDefinition>)
         */
        Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers);
    }

    static final class BuilderImpl implements Builder {
        private String lambdaArn;

        private List<EventTriggerDefinition> eventTriggers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaResource model) {
            lambdaArn(model.lambdaArn);
            eventTriggers(model.eventTriggers);
        }

        public final String getLambdaArn() {
            return lambdaArn;
        }

        public final void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @Override
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
            return this;
        }

        public final List<EventTriggerDefinition.Builder> getEventTriggers() {
            List<EventTriggerDefinition.Builder> result = EventTriggerDefinitionListCopier.copyToBuilder(this.eventTriggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventTriggers(Collection<EventTriggerDefinition.BuilderImpl> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copyFromBuilder(eventTriggers);
        }

        @Override
        public final Builder eventTriggers(Collection<EventTriggerDefinition> eventTriggers) {
            this.eventTriggers = EventTriggerDefinitionListCopier.copy(eventTriggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(EventTriggerDefinition... eventTriggers) {
            eventTriggers(Arrays.asList(eventTriggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTriggers(Consumer<EventTriggerDefinition.Builder>... eventTriggers) {
            eventTriggers(Stream.of(eventTriggers).map(c -> EventTriggerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LambdaResource build() {
            return new LambdaResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
