/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.KeyRange;
import software.amazon.awssdk.services.snowball.model.TargetOnDeviceService;
import software.amazon.awssdk.services.snowball.model.TargetOnDeviceServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Resource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Resource> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketArn").getter(S3Resource.getter(S3Resource::bucketArn)).setter(S3Resource.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketArn").build()}).build();
    private static final SdkField<KeyRange> KEY_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KeyRange").getter(S3Resource.getter(S3Resource::keyRange)).setter(S3Resource.setter(Builder::keyRange)).constructor(KeyRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyRange").build()}).build();
    private static final SdkField<List<TargetOnDeviceService>> TARGET_ON_DEVICE_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetOnDeviceServices").getter(S3Resource.getter(S3Resource::targetOnDeviceServices)).setter(S3Resource.setter(Builder::targetOnDeviceServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDeviceServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetOnDeviceService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, KEY_RANGE_FIELD, TARGET_ON_DEVICE_SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Resource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final KeyRange keyRange;
    private final List<TargetOnDeviceService> targetOnDeviceServices;

    private S3Resource(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.keyRange = builder.keyRange;
        this.targetOnDeviceServices = builder.targetOnDeviceServices;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final KeyRange keyRange() {
        return this.keyRange;
    }

    public final boolean hasTargetOnDeviceServices() {
        return this.targetOnDeviceServices != null && !(this.targetOnDeviceServices instanceof SdkAutoConstructList);
    }

    public final List<TargetOnDeviceService> targetOnDeviceServices() {
        return this.targetOnDeviceServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetOnDeviceServices() ? this.targetOnDeviceServices() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Resource)) {
            return false;
        }
        S3Resource other = (S3Resource)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.keyRange(), other.keyRange()) && this.hasTargetOnDeviceServices() == other.hasTargetOnDeviceServices() && Objects.equals(this.targetOnDeviceServices(), other.targetOnDeviceServices());
    }

    public final String toString() {
        return ToString.builder((String)"S3Resource").add("BucketArn", (Object)this.bucketArn()).add("KeyRange", (Object)this.keyRange()).add("TargetOnDeviceServices", this.hasTargetOnDeviceServices() ? this.targetOnDeviceServices() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "KeyRange": {
                return Optional.ofNullable(clazz.cast(this.keyRange()));
            }
            case "TargetOnDeviceServices": {
                return Optional.ofNullable(clazz.cast(this.targetOnDeviceServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BucketArn", BUCKET_ARN_FIELD);
        map.put("KeyRange", KEY_RANGE_FIELD);
        map.put("TargetOnDeviceServices", TARGET_ON_DEVICE_SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Resource, T> g) {
        return obj -> g.apply((S3Resource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private KeyRange keyRange;
        private List<TargetOnDeviceService> targetOnDeviceServices = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3Resource model) {
            this.bucketArn(model.bucketArn);
            this.keyRange(model.keyRange);
            this.targetOnDeviceServices(model.targetOnDeviceServices);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final KeyRange.Builder getKeyRange() {
            return this.keyRange != null ? this.keyRange.toBuilder() : null;
        }

        public final void setKeyRange(KeyRange.BuilderImpl keyRange) {
            this.keyRange = keyRange != null ? keyRange.build() : null;
        }

        @Override
        public final Builder keyRange(KeyRange keyRange) {
            this.keyRange = keyRange;
            return this;
        }

        public final List<TargetOnDeviceService.Builder> getTargetOnDeviceServices() {
            List<TargetOnDeviceService.Builder> result = TargetOnDeviceServiceListCopier.copyToBuilder(this.targetOnDeviceServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetOnDeviceServices(Collection<TargetOnDeviceService.BuilderImpl> targetOnDeviceServices) {
            this.targetOnDeviceServices = TargetOnDeviceServiceListCopier.copyFromBuilder(targetOnDeviceServices);
        }

        @Override
        public final Builder targetOnDeviceServices(Collection<TargetOnDeviceService> targetOnDeviceServices) {
            this.targetOnDeviceServices = TargetOnDeviceServiceListCopier.copy(targetOnDeviceServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetOnDeviceServices(TargetOnDeviceService ... targetOnDeviceServices) {
            this.targetOnDeviceServices(Arrays.asList(targetOnDeviceServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetOnDeviceServices(Consumer<TargetOnDeviceService.Builder> ... targetOnDeviceServices) {
            this.targetOnDeviceServices(Stream.of(targetOnDeviceServices).map(c -> (TargetOnDeviceService)((TargetOnDeviceService.Builder)TargetOnDeviceService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3Resource build() {
            return new S3Resource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Resource> {
        public Builder bucketArn(String var1);

        public Builder keyRange(KeyRange var1);

        default public Builder keyRange(Consumer<KeyRange.Builder> keyRange) {
            return this.keyRange((KeyRange)((KeyRange.Builder)KeyRange.builder().applyMutation(keyRange)).build());
        }

        public Builder targetOnDeviceServices(Collection<TargetOnDeviceService> var1);

        public Builder targetOnDeviceServices(TargetOnDeviceService ... var1);

        public Builder targetOnDeviceServices(Consumer<TargetOnDeviceService.Builder> ... var1);
    }
}

